/*
 * Decompiled with CFR 0.152.
 */
package com.cthing.cmakeed.ui.editor.handlers;

import com.cthing.cmakeed.ui.CMakeEditorPlugin;
import com.cthing.cmakeed.ui.editor.CMakeEditor;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class ToggleCommentHandler
extends AbstractHandler {
    public static final char COMMENT_CHAR = '#';

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection currentSelection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        IEditorPart activeEditor = HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
        if (currentSelection instanceof ITextSelection && activeEditor instanceof CMakeEditor) {
            ITextSelection selection = (ITextSelection)currentSelection;
            CMakeEditor editor = (CMakeEditor)activeEditor;
            if (selection.getStartLine() < 0 || selection.getEndLine() < 0) {
                return null;
            }
            IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            try {
                int opCode;
                SourceViewer sourceViewer = editor.getCMakeEditorSourceViewer();
                int offset = document.getLineOffset(selection.getStartLine());
                int n = opCode = document.getChar(offset) == '#' ? 12 : 11;
                if (sourceViewer.canDoOperation(opCode)) {
                    sourceViewer.doOperation(opCode);
                }
            }
            catch (BadLocationException e) {
                CMakeEditorPlugin.logError((Object)this, e);
            }
        }
        return null;
    }
}

