/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.terminal.connector.serial.launcher;

import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.terminal.connector.serial.launcher.ISerialWebSocketEventLauncher;
import com.espressif.idf.ui.IDFConsole;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CoreDumpPostmortemDebuggerLauncher
implements ISerialWebSocketEventLauncher {
    private static final String CORE_DUMP_POSTMORTEM_LAUNCH_CONFIG = "%s_core_dump_postmortem_debug.launch";
    private static final String GENERATED_CORE_ELF_NAME = "core.elf";
    private static final String GENERATED_CORE_DUMP_NAME = "core.dump";
    private static final String CORE_DUMP_FOLDER = "core_dump";
    private IProject project;
    private String messageReceived;
    private String elfFilePath;
    private String extractedFilePath;
    private IDFConsole idfConsole;

    public CoreDumpPostmortemDebuggerLauncher(String messageReceived, IProject project) {
        this.messageReceived = messageReceived;
        this.project = project;
        this.idfConsole = new IDFConsole();
    }

    @Override
    public IFile launchDebugSession() throws Exception {
        this.parseMessageReceived();
        this.parseExtractedFileFromPythonScript();
        this.createXMLConfig();
        this.project.refreshLocal(2, null);
        IFile launchFile = this.project.getFolder("build").getFolder(CORE_DUMP_FOLDER).getFile(String.format(CORE_DUMP_POSTMORTEM_LAUNCH_CONFIG, this.project.getName()));
        return launchFile;
    }

    private void parseExtractedFileFromPythonScript() throws Exception {
        Logger.log((String)"Converting coredump");
        String coreDumpDestination = this.getCoreDumpFileFromBuildDir(GENERATED_CORE_ELF_NAME);
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(IDFUtil.getIDFPythonEnvPath());
        commands.add(IDFUtil.getEspCoreDumpScriptFile().getAbsolutePath());
        commands.add("dbg_corefile");
        commands.add("-t");
        commands.add("b64");
        commands.add("-c");
        commands.add(this.extractedFilePath);
        commands.add("-s");
        commands.add(coreDumpDestination);
        commands.add(this.elfFilePath);
        Logger.log((String)((Object)commands).toString());
        this.executeCommands(commands);
    }

    private void executeCommands(List<String> commands) throws Exception {
        Map envMap = new IDFEnvironmentVariables().getEnvMap();
        Path pathToProject = new Path(this.project.getLocation().toString());
        this.runCommand(commands, pathToProject, envMap);
        this.project.refreshLocal(2, null);
    }

    private String runCommand(List<String> arguments, Path workDir, Map<String, String> env) throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder(arguments);
        processBuilder.directory(new File(workDir.toOSString()));
        processBuilder.environment().putAll(env);
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        Thread.sleep(100L);
        StringBuilder sBuilder = new StringBuilder();
        if (process.isAlive() && process.getInputStream() != null) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = bufferedReader.readLine();
            while (line != null) {
                sBuilder.append(line);
                sBuilder.append(System.lineSeparator());
                if (line.contains("gdb") || line.contains("GDB")) {
                    if (process.isAlive()) {
                        process.destroyForcibly();
                    }
                    line = null;
                    continue;
                }
                line = bufferedReader.readLine();
            }
        }
        Logger.log((String)sBuilder.toString());
        return sBuilder.toString();
    }

    private void parseMessageReceived() throws Exception {
        JSONParser parser = new JSONParser();
        Object obj = parser.parse(this.messageReceived);
        JSONObject jsonObject = (JSONObject)obj;
        this.extractedFilePath = jsonObject.get((Object)"file").toString();
        File file = new File(this.extractedFilePath);
        if (!file.exists()) {
            String errorMessage = "File not found: ".concat(this.extractedFilePath);
            Logger.logError((String)errorMessage);
            this.idfConsole.getConsoleStream().print(errorMessage);
            throw new Exception(errorMessage);
        }
        IFolder buildRootFolder = this.project.getFolder("build");
        StringBuilder coreDumpDestination = new StringBuilder();
        coreDumpDestination.append(buildRootFolder.getLocation().toString());
        coreDumpDestination.append('/');
        coreDumpDestination.append(CORE_DUMP_FOLDER);
        file = new File(coreDumpDestination.toString());
        if (!file.exists()) {
            Files.createDirectory(Paths.get(coreDumpDestination.toString(), new String[0]), new FileAttribute[0]);
        }
        coreDumpDestination.append('/');
        coreDumpDestination.append(GENERATED_CORE_DUMP_NAME);
        java.nio.file.Path destinationPath = Paths.get(coreDumpDestination.toString(), new String[0]);
        Files.copy(Paths.get(this.extractedFilePath, new String[0]), destinationPath, StandardCopyOption.REPLACE_EXISTING);
        this.extractedFilePath = destinationPath.toString();
        this.elfFilePath = jsonObject.get((Object)"prog").toString();
    }

    private void createXMLConfig() throws Exception {
        String stringAttribute = "stringAttribute";
        String intAttribute = "intAttribute";
        String booleanAttribute = "booleanAttribute";
        String listAttribute = "listAttribute";
        String listEntry = "listEntry";
        String key = "key";
        String value = "value";
        String booleanFalse = "false";
        String booleanTrue = "true";
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document dom = builder.newDocument();
        Element root = dom.createElement("launchConfiguration");
        dom.appendChild(root);
        Attr attr = dom.createAttribute("type");
        attr.setValue("org.eclipse.cdt.launch.postmortemLaunchType");
        root.setAttributeNode(attr);
        this.createElement(dom, root, "booleanAttribute", "org.eclipse.cdt.dsf.gdb.AUTO_SOLIB", "true");
        this.createElement(dom, root, "listAttribute", "org.eclipse.cdt.dsf.gdb.AUTO_SOLIB_LIST", null);
        this.createElement(dom, root, "stringAttribute", "org.eclipse.cdt.dsf.gdb.DEBUG_NAME", IDFUtil.getXtensaToolchainExecutablePath((IProject)this.project));
        this.createElement(dom, root, "stringAttribute", "org.eclipse.cdt.dsf.gdb.GDB_INIT", "");
        this.createElement(dom, root, "stringAttribute", "org.eclipse.cdt.dsf.gdb.POST_MORTEM_TYPE", "CORE_FILE");
        this.createElement(dom, root, "listAttribute", "org.eclipse.cdt.dsf.gdb.SOLIB_PATH", null);
        this.createElement(dom, root, "intAttribute", "org.eclipse.cdt.launch.ATTR_BUILD_BEFORE_LAUNCH_ATTR", String.valueOf(100));
        this.createElement(dom, root, "stringAttribute", "org.eclipse.cdt.launch.COREFILE_PATH", this.getCoreDumpFileFromBuildDir(GENERATED_CORE_ELF_NAME));
        this.createElement(dom, root, "stringAttribute", "org.eclipse.cdt.launch.DEBUGGER_ID", "gdb");
        this.createElement(dom, root, "stringAttribute", "org.eclipse.cdt.launch.DEBUGGER_START_MODE", "core");
        this.createElement(dom, root, "stringAttribute", "org.eclipse.cdt.launch.PROGRAM_NAME", this.elfFilePath);
        this.createElement(dom, root, "stringAttribute", "org.eclipse.cdt.launch.PROJECT_ATTR", this.project.getName());
        this.createElement(dom, root, "booleanAttribute", "org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_AUTO_ATTR", "false");
        this.createElement(dom, root, "stringAttribute", "org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", "org.eclipse.cdt.core.default.config.2083943554");
        Element listMappResPath = dom.createElement("listAttribute");
        listMappResPath.setAttribute("key", "org.eclipse.debug.core.MAPPED_RESOURCE_PATHS");
        Element subListEntryResPath = dom.createElement("listEntry");
        subListEntryResPath.setAttribute("value", "/".concat(this.project.getName()));
        listMappResPath.appendChild(subListEntryResPath);
        root.appendChild(listMappResPath);
        Element listMappResType = dom.createElement("listAttribute");
        listMappResType.setAttribute("key", "org.eclipse.debug.core.MAPPED_RESOURCE_TYPES");
        Element subListEntryResType = dom.createElement("listEntry");
        subListEntryResType.setAttribute("value", "4");
        listMappResType.appendChild(subListEntryResType);
        root.appendChild(listMappResType);
        Transformer tr = TransformerFactory.newInstance().newTransformer();
        tr.setOutputProperty("indent", "yes");
        String launchFile = this.getCoreDumpFileFromBuildDir(String.format(CORE_DUMP_POSTMORTEM_LAUNCH_CONFIG, this.project.getName()));
        tr.transform(new DOMSource(dom), new StreamResult(new File(launchFile)));
        this.project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
    }

    private String getCoreDumpFileFromBuildDir(String fileName) {
        IFolder buildRootFolder = this.project.getFolder("build");
        StringBuilder coreDumpDestination = new StringBuilder();
        coreDumpDestination.append(buildRootFolder.getLocation().toString());
        coreDumpDestination.append('/');
        coreDumpDestination.append(CORE_DUMP_FOLDER);
        coreDumpDestination.append('/');
        coreDumpDestination.append(fileName);
        return coreDumpDestination.toString();
    }

    private Element createElement(Document dom, Element root, String attribName, String key, String value) {
        Element element = dom.createElement(attribName);
        element.setAttribute("key", key);
        if (value != null) {
            element.setAttribute("value", value);
        }
        root.appendChild(element);
        return element;
    }
}

