/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.terminal.connector.serial.connector;

import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.terminal.connector.serial.activator.Activator;
import com.espressif.idf.terminal.connector.serial.connector.SerialPortHandler;
import com.espressif.idf.terminal.connector.serial.connector.SerialSettings;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.provider.TerminalConnectorImpl;

public class SerialConnector
extends TerminalConnectorImpl {
    private SerialSettings settings = new SerialSettings();
    protected Process process;
    protected Thread thread;
    protected IProject project;
    protected String filterOptions;
    protected ITerminalControl control;
    private SerialPortHandler serialPort;
    private static Set<String> openPorts = new HashSet<String>();

    public static boolean isOpen(String portName) {
        return openPorts.contains(portName);
    }

    public OutputStream getTerminalToRemoteStream() {
        return this.process.getOutputStream();
    }

    public SerialSettings getSettings() {
        return this.settings;
    }

    public String getSettingsSummary() {
        return this.settings.getSummary();
    }

    public void load(ISettingsStore store) {
        this.settings.load(store);
    }

    public void save(ISettingsStore store) {
        this.settings.save(store);
    }

    public void connect(ITerminalControl control) {
        super.connect(control);
        this.control = control;
        this.project = this.settings.getProject();
        if (this.project == null) {
            String message = "project can't be null. Make sure you select a project before launch a serial monitor";
            Activator.log((IStatus)new Status(4, Activator.getUniqueIdentifier(), message, null));
            return;
        }
        String portName = this.settings.getPortName();
        this.filterOptions = this.settings.getFilterText();
        this.filterOptions = StringUtil.isEmpty((String)this.filterOptions) ? "" : this.filterOptions;
        this.serialPort = new SerialPortHandler(portName, this, this.project);
        this.serialPort.open();
        openPorts.add(this.serialPort.getPortName());
    }

    protected void doDisconnect() {
        if (this.serialPort != null && this.serialPort.isOpen()) {
            openPorts.remove(this.serialPort.getPortName());
            try {
                this.serialPort.close();
            }
            catch (IOException e) {
                Activator.log(e);
            }
        }
    }
}

