/*
 * Decompiled with CFR 0.152.
 */
package com.cthing.cmakeed.ui.editor;

import com.cthing.cmakeed.ui.CMakeEditorPlugin;
import com.cthing.cmakeed.ui.editor.CMakePartitionScanner;
import com.cthing.cmakeed.ui.editor.CMakeScanner;
import com.cthing.cmakeed.ui.editor.ColorMgr;
import com.cthing.cmakeed.ui.prefs.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.PlatformUI;

public class CMakeScannerMgr {
    private ColorMgr colorMgr;

    public CMakeScannerMgr(ColorMgr colorMgr) {
        this.colorMgr = colorMgr;
    }

    public ITokenScanner getScanner(String contentType) {
        if (CMakePartitionScanner.isDefault(contentType)) {
            return this.getCMakeScanner();
        }
        if (CMakePartitionScanner.isComment(contentType)) {
            return this.getCommentScanner();
        }
        if (CMakePartitionScanner.isVariable(contentType)) {
            return this.getArgumentScanner();
        }
        if (CMakePartitionScanner.isString(contentType)) {
            return this.getStringScanner();
        }
        if (CMakePartitionScanner.isCommand(contentType)) {
            return this.getCommandScanner();
        }
        if (CMakePartitionScanner.isDepCommand(contentType)) {
            return this.getDepCommandScanner();
        }
        if (CMakePartitionScanner.isCMakeVariable(contentType)) {
            return this.getCMakeVariableScanner();
        }
        if (CMakePartitionScanner.isProperty(contentType)) {
            return this.getPropertyScanner();
        }
        if (CMakePartitionScanner.isReservedWord(contentType)) {
            return this.getReservedWordScanner();
        }
        if (CMakePartitionScanner.isUserVariable(contentType)) {
            return this.getUserVariableScanner();
        }
        if (CMakePartitionScanner.isArgsOpen(contentType) || CMakePartitionScanner.isArgsClose(contentType)) {
            return this.getCMakeScanner();
        }
        return null;
    }

    private CMakeScanner getCMakeScanner() {
        CMakeScanner scanner = new CMakeScanner();
        return scanner;
    }

    private RuleBasedPartitionScanner getCommentScanner() {
        return this.createRuleBasedScanner("comment");
    }

    private RuleBasedPartitionScanner getArgumentScanner() {
        return this.createRuleBasedScanner("variable");
    }

    private RuleBasedPartitionScanner getStringScanner() {
        return this.createRuleBasedScanner("string");
    }

    private RuleBasedPartitionScanner getCommandScanner() {
        return this.createRuleBasedScanner("command");
    }

    private RuleBasedPartitionScanner getDepCommandScanner() {
        return this.createRuleBasedScanner("depCommand");
    }

    private RuleBasedPartitionScanner getCMakeVariableScanner() {
        return this.createRuleBasedScanner("cmake_variable");
    }

    private RuleBasedPartitionScanner getPropertyScanner() {
        return this.createRuleBasedScanner("cmake_property");
    }

    private RuleBasedPartitionScanner getReservedWordScanner() {
        return this.createRuleBasedScanner("cmake_reserved_word");
    }

    private RuleBasedPartitionScanner getUserVariableScanner() {
        return this.createRuleBasedScanner("cmake_user_variable");
    }

    private RuleBasedPartitionScanner createRuleBasedScanner(String baseKey) {
        ColorRegistry registry = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        Color color = registry.get("com.cthing.cmakeed.ui." + Preferences.getColorKey(baseKey));
        IPreferenceStore store = CMakeEditorPlugin.getDefault().getPreferenceStore();
        int style = store.getInt(Preferences.getStyleKey(baseKey));
        RuleBasedPartitionScanner scanner = new RuleBasedPartitionScanner();
        TextAttribute attr = new TextAttribute(color, null, style);
        scanner.setDefaultReturnToken((IToken)new Token((Object)attr));
        return scanner;
    }
}

