/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.terminal.connector.launcher;

import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.terminal.connector.activator.UIPlugin;
import com.espressif.idf.terminal.connector.controls.IDFConsoleWizardConfigurationPanel;
import com.espressif.idf.terminal.connector.launcher.IDFConsoleMementoHandler;
import com.espressif.idf.terminal.connector.launcher.Messages;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalConnectorExtension;
import org.eclipse.tm.terminal.connector.process.ProcessSettings;
import org.eclipse.tm.terminal.view.core.TerminalServiceFactory;
import org.eclipse.tm.terminal.view.core.interfaces.ITerminalService;
import org.eclipse.tm.terminal.view.core.interfaces.ITerminalServiceOutputStreamMonitorListener;
import org.eclipse.tm.terminal.view.ui.interfaces.IConfigurationPanel;
import org.eclipse.tm.terminal.view.ui.interfaces.IConfigurationPanelContainer;
import org.eclipse.tm.terminal.view.ui.interfaces.IMementoHandler;
import org.eclipse.tm.terminal.view.ui.internal.SettingsStore;
import org.eclipse.tm.terminal.view.ui.launcher.AbstractLauncherDelegate;
import org.eclipse.ui.WorkbenchEncoding;
import org.osgi.framework.Bundle;

public class IDFConsoleLauncherDelegate
extends AbstractLauncherDelegate {
    private static final String ESP_IDF_CONSOLE_CONNECTOR_ID = "com.espressif.idf.terminal.connector.espidfConnector";
    private final IMementoHandler mementoHandler = new IDFConsoleMementoHandler();

    public boolean needsUserConfiguration() {
        return false;
    }

    public IConfigurationPanel getPanel(IConfigurationPanelContainer container) {
        return new IDFConsoleWizardConfigurationPanel(container);
    }

    public void execute(Map<String, Object> properties, ITerminalService.Done done) {
        ITerminalService terminal;
        Assert.isNotNull(properties);
        this.setTerminalTitle(properties);
        if (!properties.containsKey("encoding")) {
            String encoding = null;
            encoding = "macosx".equals(Platform.getOS()) || "win32".equals(Platform.getOS()) ? "UTF-8" : WorkbenchEncoding.getWorkbenchDefaultEncoding();
            if (encoding != null && !"".equals(encoding)) {
                properties.put("encoding", encoding);
            }
        }
        if (!properties.containsKey("terminal.forceNew")) {
            properties.put("terminal.forceNew", Boolean.TRUE);
        }
        if (!properties.containsKey("process.working_dir")) {
            String cwd;
            block19: {
                String initialCwd = org.eclipse.tm.terminal.view.ui.activator.UIPlugin.getScopedPreferences().getString("terminals.localTerminalInitialCwd");
                cwd = null;
                if (initialCwd == null || "userhome".equals(initialCwd) || "".equals(initialCwd.trim())) {
                    cwd = System.getProperty("user.home");
                } else if ("eclipsehome".equals(initialCwd)) {
                    String eclipseHomeLocation = System.getProperty("eclipse.home.location");
                    if (eclipseHomeLocation != null) {
                        try {
                            URI uri = URIUtil.fromString((String)eclipseHomeLocation);
                            File f = URIUtil.toFile((URI)uri);
                            cwd = f.getAbsolutePath();
                        }
                        catch (URISyntaxException uri) {}
                    }
                } else if ("eclipsews".equals(initialCwd)) {
                    Bundle bundle = Platform.getBundle((String)"org.eclipse.core.resources");
                    if (bundle != null && bundle.getState() != 1 && bundle.getState() != 16 && ResourcesPlugin.getWorkspace() != null && ResourcesPlugin.getWorkspace().getRoot() != null && ResourcesPlugin.getWorkspace().getRoot().getLocation() != null) {
                        cwd = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
                    }
                } else {
                    try {
                        IStringVariableManager vm = VariablesPlugin.getDefault().getStringVariableManager();
                        String resolved = vm.performStringSubstitution(initialCwd);
                        Path p = new Path(resolved);
                        if (p.toFile().canRead() && p.toFile().isDirectory()) {
                            cwd = p.toOSString();
                        }
                    }
                    catch (CoreException ex) {
                        if (!Platform.inDebugMode()) break block19;
                        UIPlugin.getDefault().getLog().log(ex.getStatus());
                    }
                }
            }
            if (cwd != null && !"".equals(cwd)) {
                properties.put("process.working_dir", cwd);
            }
        }
        if ((terminal = TerminalServiceFactory.getService()) != null) {
            terminal.openConsole(properties, done);
        }
    }

    private void setTerminalTitle(Map<String, Object> properties) {
        if (properties.containsKey("title")) {
            Object projectName = properties.get("title");
            properties.put("title", String.format("%s (%s)", projectName, Messages.IDFConsoleLauncherDelegate_ESPIDFTerminal));
        } else {
            properties.put("title", Messages.IDFConsoleLauncherDelegate_ESPIDFTerminal);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IMementoHandler.class.equals(adapter)) {
            return adapter.cast(this.mementoHandler);
        }
        return (T)super.getAdapter(adapter);
    }

    private final File defaultShell() {
        String shell = null;
        if ("win32".equals(Platform.getOS())) {
            shell = System.getenv("ComSpec") != null && !"".equals(System.getenv("ComSpec").trim()) ? System.getenv("ComSpec").trim() : "cmd.exe";
        }
        if (shell == null && ((shell = org.eclipse.tm.terminal.view.ui.activator.UIPlugin.getScopedPreferences().getString("terminals.localTerminalDefaultShellUnix")) == null || "".equals(shell))) {
            shell = System.getenv("SHELL") != null && !"".equals(System.getenv("SHELL").trim()) ? System.getenv("SHELL").trim() : "/bin/sh";
        }
        return new File(shell);
    }

    public ITerminalConnector createTerminalConnector(Map<String, Object> properties) {
        Bundle bundle;
        String eclipseHomeLocation;
        String title;
        File defaultShell;
        Assert.isNotNull(properties);
        String connectorId = (String)properties.get("tm.terminal.connector.id");
        if (connectorId == null) {
            connectorId = ESP_IDF_CONSOLE_CONNECTOR_ID;
        }
        String image = !properties.containsKey("process.path") || properties.get("process.path") == null ? ((defaultShell = this.defaultShell()).isAbsolute() ? defaultShell.getAbsolutePath() : defaultShell.getPath()) : (String)properties.get("process.path");
        Object arguments = (String)properties.get("process.args");
        if (arguments == null && !"win32".equals(Platform.getOS())) {
            arguments = org.eclipse.tm.terminal.view.ui.activator.UIPlugin.getScopedPreferences().getString("terminals.localTerminalDefaultShellUnixArgs");
        }
        arguments = "";
        if (image.contains("bash")) {
            arguments = "--noprofile --norc";
        } else if (image.contains("zsh")) {
            arguments = "--no-rcs --no-globalrcs";
        } else if (image.contains("powershell")) {
            arguments = "-NoProfile";
        } else if ("win32".equals(Platform.getOS()) && image.contains("cmd.exe") && (title = (String)properties.get("title")) != null && !title.isEmpty()) {
            String safeTitle = title.replaceAll("[\\r\\n\"&|<>^]", " ").trim();
            arguments = "/c \"title " + safeTitle + " && cmd.exe\"";
        }
        boolean isUsingPTY = properties.get("process") == null && PTY.isSupported((PTY.Mode)PTY.Mode.TERMINAL) || properties.get("pty") instanceof PTY;
        boolean localEcho = false;
        if (!properties.containsKey("localEcho") || !(properties.get("localEcho") instanceof Boolean)) {
            if ("win32".equals(Platform.getOS())) {
                localEcho = !isUsingPTY;
            }
        } else {
            localEcho = (Boolean)properties.get("localEcho");
        }
        String lineSeparator = null;
        if (!properties.containsKey("lineSeparator") || !(properties.get("lineSeparator") instanceof String)) {
            if (!isUsingPTY) {
                lineSeparator = "win32".equals(Platform.getOS()) ? "\\r\\n" : "\\n";
            }
        } else {
            lineSeparator = (String)properties.get("lineSeparator");
        }
        Process process = (Process)properties.get("process");
        PTY pty = (PTY)properties.get("pty");
        ITerminalServiceOutputStreamMonitorListener[] stdoutListeners = (ITerminalServiceOutputStreamMonitorListener[])properties.get("stdoutListeners");
        ITerminalServiceOutputStreamMonitorListener[] stderrListeners = (ITerminalServiceOutputStreamMonitorListener[])properties.get("stderrListeners");
        String workingDir = (String)properties.get("process.working_dir");
        String[] envp = null;
        if (properties.containsKey("process.environment") && properties.get("process.environment") != null && properties.get("process.environment") instanceof String[]) {
            envp = (String[])properties.get("process.environment");
        }
        ArrayList<Object> envpList = new ArrayList<Object>();
        if (envp != null) {
            envpList.addAll(Arrays.asList(envp));
        }
        if ((eclipseHomeLocation = System.getProperty("eclipse.home.location")) != null) {
            try {
                URI uri = URIUtil.fromString((String)eclipseHomeLocation);
                File f = URIUtil.toFile((URI)uri);
                envpList.add("ECLIPSE_HOME=" + f.getAbsolutePath());
            }
            catch (URISyntaxException uri) {
                // empty catch block
            }
        }
        if ((bundle = Platform.getBundle((String)"org.eclipse.core.resources")) != null && bundle.getState() != 1 && bundle.getState() != 16 && ResourcesPlugin.getWorkspace() != null && ResourcesPlugin.getWorkspace().getRoot() != null && ResourcesPlugin.getWorkspace().getRoot().getLocation() != null) {
            envpList.add("ECLIPSE_WORKSPACE=" + ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
        }
        Map envMap = new IDFEnvironmentVariables().getSystemEnvMap();
        Set keySet = envMap.keySet();
        if (envMap.containsKey("PATH") && envMap.containsKey("Path")) {
            envMap.remove("Path");
        }
        String idfToolsPath = Paths.get(IDFUtil.getIDFPath(), "tools").toAbsolutePath().toString();
        String currentPath = (String)envMap.get("PATH");
        if (currentPath != null && !currentPath.contains(idfToolsPath)) {
            envMap.put("PATH", currentPath + File.pathSeparator + idfToolsPath);
        }
        for (String envKey : keySet) {
            String idfExtraPaths;
            Object envValue = (String)envMap.get(envKey);
            if (envKey.equals("PATH") && !StringUtil.isEmpty((String)(idfExtraPaths = IDFUtil.getIDFExtraPaths()))) {
                envValue = idfExtraPaths + ":" + (String)envValue;
            }
            envpList.add(envKey + "=" + (String)envValue);
        }
        envp = envpList.toArray(new String[envpList.size()]);
        Assert.isTrue((image != null || process != null ? 1 : 0) != 0);
        SettingsStore store = new SettingsStore();
        ProcessSettings processSettings = new ProcessSettings();
        processSettings.setImage(image);
        processSettings.setArguments((String)arguments);
        processSettings.setProcess(process);
        processSettings.setPTY(pty);
        processSettings.setLocalEcho(localEcho);
        processSettings.setLineSeparator(lineSeparator);
        processSettings.setStdOutListeners(stdoutListeners);
        processSettings.setStdErrListeners(stderrListeners);
        processSettings.setWorkingDir(workingDir);
        processSettings.setEnvironment(envp);
        if (properties.containsKey("process.environment.merge")) {
            Object value = properties.get("process.environment.merge");
            processSettings.setMergeWithNativeEnvironment(value instanceof Boolean ? (Boolean)value : false);
        }
        processSettings.save((ISettingsStore)store);
        ITerminalConnector connector = TerminalConnectorExtension.makeTerminalConnector((String)connectorId);
        if (connector != null) {
            connector.setDefaultSettings();
            connector.load((ISettingsStore)store);
        }
        return connector;
    }
}

