/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.debug.gdbjtag.openocd.dsf.process;

import com.espressif.idf.core.build.ReHintPair;
import com.espressif.idf.core.logging.LogFileWriterManager;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.HintsUtil;
import com.espressif.idf.debug.gdbjtag.openocd.dsf.console.IdfProcessConsole;
import com.espressif.idf.debug.gdbjtag.openocd.dsf.console.IdfProcessConsoleFactory;
import com.espressif.idf.debug.gdbjtag.openocd.ui.Messages;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.List;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IFlushableStreamMonitor;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class StreamListener
implements IStreamListener {
    private static final String OPENOCD_FAQ_LINK = "https://github.com/espressif/openocd-esp32/wiki/Troubleshooting-FAQ";
    private IOConsoleOutputStream fConsoleErrorOutputStream;
    private IOConsoleOutputStream fConsoleOutputStream;
    private IStreamMonitor fErrorStreamMonitor;
    private IStreamMonitor fOutputStreamMonitor;
    private IdfProcessConsole idfProcessConsole;
    private boolean fStreamClosed = false;
    private List<ReHintPair> reHintsList;
    private final PrintWriter fileWriter;
    private final String resolvedOutputFilePath;

    public StreamListener(IProcess iProcess, IStreamMonitor errorStreamMonitor, IStreamMonitor outputStreamMonitor, Charset charset, String outputFile, boolean append) {
        this.fErrorStreamMonitor = errorStreamMonitor;
        this.fOutputStreamMonitor = outputStreamMonitor;
        this.resolvedOutputFilePath = StreamListener.resolveOutputFilePath(outputFile);
        this.idfProcessConsole = IdfProcessConsoleFactory.showAndActivateConsole(charset);
        if (iProcess.getLabel().contains("openocd")) {
            this.idfProcessConsole.clearConsole();
        }
        this.fileWriter = LogFileWriterManager.getWriter((String)this.resolvedOutputFilePath, (boolean)append);
        this.reHintsList = HintsUtil.getReHintsList((File)new File(HintsUtil.getOpenocdHintsYmlPath()));
        this.fConsoleErrorOutputStream = this.idfProcessConsole.getErrorStream();
        this.fConsoleErrorOutputStream.setActivateOnWrite(true);
        this.fConsoleOutputStream = this.idfProcessConsole.getOutputStream();
        this.fConsoleOutputStream.setActivateOnWrite(true);
        this.flushAndDisableBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushAndDisableBuffer() {
        IFlushableStreamMonitor m;
        IStreamMonitor iStreamMonitor;
        String contents;
        IStreamMonitor iStreamMonitor2 = this.fErrorStreamMonitor;
        synchronized (iStreamMonitor2) {
            contents = this.fErrorStreamMonitor.getContents();
            iStreamMonitor = this.fErrorStreamMonitor;
            if (iStreamMonitor instanceof IFlushableStreamMonitor) {
                m = (IFlushableStreamMonitor)iStreamMonitor;
                m.flushContents();
                m.setBuffered(false);
            }
            this.streamAppended(contents, this.fErrorStreamMonitor);
        }
        iStreamMonitor2 = this.fOutputStreamMonitor;
        synchronized (iStreamMonitor2) {
            contents = this.fOutputStreamMonitor.getContents();
            iStreamMonitor = this.fOutputStreamMonitor;
            if (iStreamMonitor instanceof IFlushableStreamMonitor) {
                m = (IFlushableStreamMonitor)iStreamMonitor;
                m.flushContents();
                m.setBuffered(false);
            }
            this.streamAppended(contents, this.fOutputStreamMonitor);
        }
    }

    public void streamAppended(String text, IStreamMonitor monitor) {
        text.lines().forEach(line -> {
            this.fileWriter.println((String)line);
            try {
                if (line.startsWith("Error:") && this.fConsoleErrorOutputStream != null) {
                    this.fConsoleErrorOutputStream.write((line + System.lineSeparator()).getBytes());
                    this.fConsoleErrorOutputStream.flush();
                    boolean[] hintMatched = new boolean[1];
                    this.reHintsList.stream().filter(reHintEntry -> reHintEntry.getRe().map(pattern -> pattern.matcher((CharSequence)line).find() || line.contains(pattern.toString())).orElse(false)).forEach(matchedReHintEntry -> {
                        try {
                            blArray[0] = true;
                            String cyanHint = "\u001b[36mHint: " + matchedReHintEntry.getHint() + "\u001b[0m";
                            this.fConsoleOutputStream.write(cyanHint + System.lineSeparator() + matchedReHintEntry.getRef().orElse("") + System.lineSeparator());
                            this.fConsoleOutputStream.flush();
                        }
                        catch (IOException e) {
                            Logger.log((Exception)e);
                        }
                    });
                    if (!hintMatched[0] && this.fConsoleOutputStream != null) {
                        this.fConsoleOutputStream.write((Messages.OpenOCDConsole_ErrorGuideMessage + System.lineSeparator() + OPENOCD_FAQ_LINK + System.lineSeparator()).getBytes());
                    }
                } else if (this.fConsoleOutputStream != null) {
                    this.fConsoleOutputStream.write((line + System.lineSeparator()).getBytes());
                    this.fConsoleOutputStream.flush();
                }
            }
            catch (IOException e) {
                Logger.log((Exception)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeStreams() {
        IStreamMonitor iStreamMonitor = this.fErrorStreamMonitor;
        synchronized (iStreamMonitor) {
            this.fErrorStreamMonitor.removeListener((IStreamListener)this);
        }
        iStreamMonitor = this.fOutputStreamMonitor;
        synchronized (iStreamMonitor) {
            this.fOutputStreamMonitor.removeListener((IStreamListener)this);
        }
        this.fStreamClosed = true;
    }

    public void dispose() {
        if (!this.fStreamClosed) {
            this.closeStreams();
        }
        if (this.resolvedOutputFilePath != null) {
            LogFileWriterManager.closeWriter((String)this.resolvedOutputFilePath);
        }
        this.fErrorStreamMonitor = null;
        this.fOutputStreamMonitor = null;
    }

    private static String resolveOutputFilePath(String outputFile) {
        if (outputFile == null || outputFile.isEmpty()) {
            return null;
        }
        try {
            File parent;
            String expanded = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(outputFile);
            File file = new File(expanded);
            if (file.isDirectory() || !file.exists() && expanded.endsWith(File.separator)) {
                file = new File(file, "openocd.log");
            }
            if ((parent = file.getParentFile()) != null && !parent.exists()) {
                parent.mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            return file.getAbsolutePath();
        }
        catch (Exception e) {
            Logger.log((Exception)e);
            return null;
        }
    }
}

