/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.debug.gdbjtag.openocd.dsf.console;

import com.espressif.idf.core.logging.Logger;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleInputStream;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;

public class IdfProcessConsole
extends IOConsole
implements IPropertyChangeListener {
    public static final String CONSOLE_NAME = "IDF Process Console";
    public static final String CONSOLE_TYPE = "com.espressif.idf.debug.gdbjtag.openocd.dsf.console.IdfProcessConsole";
    private IOConsoleOutputStream outputStream;
    private IOConsoleOutputStream errorStream;
    private IOConsoleOutputStream warnStream;
    private IOConsoleInputStream inputStream = this.getInputStream();
    private URLPatternMatchListener urlPatternMatchListener;

    public IdfProcessConsole(Charset charset) {
        super(CONSOLE_NAME, CONSOLE_TYPE, null, charset, true);
        this.outputStream = this.newOutputStream();
        this.errorStream = this.newOutputStream();
        this.warnStream = this.newOutputStream();
        this.urlPatternMatchListener = new URLPatternMatchListener(this);
    }

    public void init() {
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        store.addPropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        this.outputStream.setColor(DebugUIPlugin.getPreferenceColor((String)"org.eclipse.debug.ui.outColor"));
        this.errorStream.setColor(DebugUIPlugin.getPreferenceColor((String)"org.eclipse.debug.ui.errorColor"));
        if (store.getBoolean("Console.wrap")) {
            this.setConsoleWidth(store.getInt("Console.width"));
        }
        this.setTabWidth(store.getInt("Console.console_tab_width"));
        if (store.getBoolean("Console.limitConsoleOutput")) {
            int highWater = store.getInt("Console.highWaterMark");
            int lowWater = store.getInt("Console.lowWaterMark");
            this.setWaterMarks(lowWater, highWater);
        }
        this.setHandleControlCharacters(store.getBoolean("Console.interpret_control_characters"));
        this.setCarriageReturnAsControlCharacter(store.getBoolean("Console.interpret_cr_as_control_characters"));
        DebugUIPlugin.getStandardDisplay().asyncExec(() -> {
            this.setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.consoleFont"));
            this.setBackground(DebugUIPlugin.getPreferenceColor((String)"org.eclipse.debug.ui.consoleBackground"));
        });
        this.addPatternMatchListener(this.urlPatternMatchListener);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getProperty();
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        if (property.equals("Console.wrap") || property.equals("Console.width")) {
            boolean fixedWidth = store.getBoolean("Console.wrap");
            if (fixedWidth) {
                int width = store.getInt("Console.width");
                this.setConsoleWidth(width);
            } else {
                this.setConsoleWidth(-1);
            }
        } else if (property.equals("Console.limitConsoleOutput") || property.equals("Console.highWaterMark") || property.equals("Console.lowWaterMark")) {
            boolean limitBufferSize = store.getBoolean("Console.limitConsoleOutput");
            if (limitBufferSize) {
                int lowWater;
                int highWater = store.getInt("Console.highWaterMark");
                if (highWater > (lowWater = store.getInt("Console.lowWaterMark"))) {
                    this.setWaterMarks(lowWater, highWater);
                }
            } else {
                this.setWaterMarks(-1, -1);
            }
        } else if (property.equals("Console.console_tab_width")) {
            int tabWidth = store.getInt("Console.console_tab_width");
            this.setTabWidth(tabWidth);
        } else if (property.equals("DEBUG.consoleOpenOnOut")) {
            boolean activateOnOut = store.getBoolean("DEBUG.consoleOpenOnOut");
            if (this.outputStream != null) {
                this.outputStream.setActivateOnWrite(activateOnOut);
            }
        } else if (property.equals("DEBUG.consoleOpenOnErr")) {
            boolean activateOnErr = store.getBoolean("DEBUG.consoleOpenOnErr");
            if (this.errorStream != null) {
                this.errorStream.setActivateOnWrite(activateOnErr);
            }
        } else if (property.equals("org.eclipse.debug.ui.outColor")) {
            if (this.outputStream != null) {
                this.outputStream.setColor(DebugUIPlugin.getPreferenceColor((String)"org.eclipse.debug.ui.outColor"));
            }
        } else if (property.equals("org.eclipse.debug.ui.errorColor")) {
            if (this.errorStream != null) {
                this.errorStream.setColor(DebugUIPlugin.getPreferenceColor((String)"org.eclipse.debug.ui.errorColor"));
            }
        } else if (property.equals("org.eclipse.debug.ui.inColor")) {
            if (this.inputStream != null && this.inputStream instanceof IOConsoleInputStream) {
                this.inputStream.setColor(DebugUIPlugin.getPreferenceColor((String)"org.eclipse.debug.ui.inColor"));
            }
        } else if (property.equals("org.eclipse.debug.ui.consoleFont")) {
            this.setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.consoleFont"));
        } else if (property.equals("org.eclipse.debug.ui.consoleBackground")) {
            this.setBackground(DebugUIPlugin.getPreferenceColor((String)"org.eclipse.debug.ui.consoleBackground"));
        } else if (property.equals("Console.interpret_control_characters")) {
            this.setHandleControlCharacters(store.getBoolean("Console.interpret_control_characters"));
        } else if (property.equals("Console.interpret_cr_as_control_characters")) {
            this.setCarriageReturnAsControlCharacter(store.getBoolean("Console.interpret_cr_as_control_characters"));
        }
    }

    public IOConsoleOutputStream getOutputStream() {
        return this.outputStream;
    }

    public IOConsoleOutputStream getErrorStream() {
        return this.errorStream;
    }

    public IOConsoleOutputStream getWarnStream() {
        return this.warnStream;
    }

    private class URLPatternMatchListener
    implements IPatternMatchListener {
        private IdfProcessConsole idfProcessConsole;
        private Pattern urlPattern;

        public URLPatternMatchListener(IdfProcessConsole idfProcessConsole2) {
            this.idfProcessConsole = idfProcessConsole2;
            this.urlPattern = Pattern.compile("http[s]?://\\S+");
        }

        public String getPattern() {
            return this.urlPattern.pattern();
        }

        public void matchFound(PatternMatchEvent event) {
            try {
                int offset = event.getOffset();
                int length = event.getLength();
                final String detectedUrl = this.idfProcessConsole.getDocument().get(offset, length);
                IHyperlink link = new IHyperlink(){

                    public void linkActivated() {
                        try {
                            Program.launch((String)detectedUrl);
                        }
                        catch (Exception e) {
                            Logger.log((Exception)e);
                        }
                    }

                    public void linkExited() {
                    }

                    public void linkEntered() {
                    }
                };
                this.idfProcessConsole.addHyperlink(link, offset, length);
            }
            catch (Exception e) {
                Logger.log((Exception)e);
            }
        }

        public void connect(TextConsole console) {
        }

        public void disconnect() {
        }

        public int getCompilerFlags() {
            return 0;
        }

        public String getLineQualifier() {
            return null;
        }
    }
}

