/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.terminal.connector.serial.server;

import com.espressif.idf.core.logging.Logger;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;

public class TerminalWebSocketServer
extends WebSocketServer {
    private ConcurrentLinkedQueue<String> messagesReceivedQueue = new ConcurrentLinkedQueue();

    public TerminalWebSocketServer(int port) {
        super(new InetSocketAddress(port));
    }

    public void onClose(WebSocket conn, int code, String reason, boolean remote) {
        this.broadcast(String.valueOf(conn) + " is terminated!");
        Logger.log((String)(String.valueOf(conn) + " is terminated!"));
    }

    public void onError(WebSocket conn, Exception ex) {
        Logger.log((Exception)ex);
    }

    public void onMessage(WebSocket connection, String message) {
        Logger.log((String)"message received:");
        Logger.log((String)message);
        this.messagesReceivedQueue.add(message);
    }

    public void onOpen(WebSocket conn, ClientHandshake clientHandshake) {
        Logger.log((String)"Connection Made to: ");
        Logger.log((String)conn.getRemoteSocketAddress().getAddress().getHostAddress());
    }

    public void onStart() {
        Logger.log((String)"Server started!");
        this.setConnectionLostTimeout(0);
        this.setConnectionLostTimeout(100);
    }

    public ConcurrentLinkedQueue<String> getMessagesReceivedQueue() {
        return this.messagesReceivedQueue;
    }

    public void setMessagesReceivedQueue(ConcurrentLinkedQueue<String> messagesReceivedQueue) {
        this.messagesReceivedQueue = messagesReceivedQueue;
    }
}

