/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.terminal.connector.serial.controls;

import com.espressif.idf.core.IDFProjectNature;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.terminal.connector.serial.activator.Activator;
import com.espressif.idf.terminal.connector.serial.connector.SerialConnector;
import com.espressif.idf.terminal.connector.serial.connector.SerialSettings;
import com.espressif.idf.terminal.connector.serial.nls.Messages;
import com.espressif.idf.ui.EclipseUtil;
import java.io.IOException;
import java.util.Optional;
import org.eclipse.cdt.serial.SerialPort;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tm.internal.terminal.provisional.api.AbstractSettingsPage;
import org.eclipse.tm.terminal.view.ui.interfaces.IConfigurationPanel;
import org.eclipse.tm.terminal.view.ui.interfaces.IConfigurationPanelContainer;

public class SerialSettingsPage
extends AbstractSettingsPage {
    private final SerialSettings settings;
    private final IConfigurationPanel panel;
    private final IDialogSettings dialogSettings;
    private Combo portCombo;
    private Combo projectCombo;
    private String lastUsedSerialPort;
    private Text filterText;
    private String filterConfig;

    public SerialSettingsPage(SerialSettings settings, IConfigurationPanel panel) {
        this.settings = settings;
        this.panel = panel;
        this.setHasControlDecoration(true);
        this.dialogSettings = DialogSettings.getOrCreateSection((IDialogSettings)Activator.getDefault().getDialogSettings(), (String)((Object)((Object)this)).getClass().getSimpleName());
        this.dialogSettings.get("cdtserial.portName");
        this.filterConfig = this.dialogSettings.get("idf.monitor.filter");
        this.lastUsedSerialPort = this.getLastUsedSerialPort();
    }

    protected String getLastUsedSerialPort() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("com.espressif.idf.launch.serial.ui");
        return preferences.get("com.espressif.idf.launch.serial.core.serialPort", "");
    }

    public void createControl(Composite parent) {
        IProject[] projects;
        Composite comp = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        GridData gridData = new GridData(768);
        comp.setLayout((Layout)gridLayout);
        comp.setLayoutData((Object)gridData);
        Label projectLabel = new Label(comp, 0);
        projectLabel.setText(Messages.SerialSettingsPage_ProjectName);
        this.projectCombo = new Combo(comp, 0);
        this.projectCombo.setLayoutData((Object)new GridData(768));
        Optional<IProject> optProject = Optional.ofNullable(EclipseUtil.getSelectedIDFProjectInExplorer());
        optProject.ifPresent(project -> this.projectCombo.setText(project.getName()));
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project2 = iProjectArray[n2];
            try {
                if (project2.hasNature(IDFProjectNature.ID)) {
                    this.projectCombo.add(project2.getName());
                }
            }
            catch (CoreException e1) {
                Logger.log((Exception)((Object)e1));
            }
            ++n2;
        }
        Label portLabel = new Label(comp, 0);
        portLabel.setText(Messages.SerialTerminalSettingsPage_SerialPort);
        this.portCombo = new Combo(comp, 0);
        this.portCombo.setLayoutData((Object)new GridData(768));
        String[] portNames = new String[]{};
        try {
            portNames = SerialPort.list();
        }
        catch (IOException e) {
            Activator.log(e);
        }
        String[] stringArray = portNames;
        int n3 = portNames.length;
        int n4 = 0;
        while (n4 < n3) {
            String portName = stringArray[n4];
            if (!SerialConnector.isOpen(portName)) {
                this.portCombo.add(portName);
            }
            ++n4;
        }
        this.portCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SerialSettingsPage.this.validate();
            }
        });
        Label configOptions = new Label(comp, 0);
        configOptions.setText(Messages.SerialSettingsPage_FilterOptions);
        this.filterText = new Text(comp, 2052);
        this.filterText.setLayoutData((Object)new GridData(768));
        this.loadSettings();
    }

    void validate() {
        IConfigurationPanelContainer container = this.panel.getContainer();
        container.validate();
    }

    public void loadSettings() {
        String portName = this.settings.getPortName();
        if (portName == null || portName.isEmpty()) {
            portName = this.lastUsedSerialPort;
        }
        if (portName != null && !portName.isEmpty() && !SerialConnector.isOpen(portName)) {
            int i = 0;
            String[] stringArray = this.portCombo.getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (portName.equals(name)) {
                    this.portCombo.select(i);
                    break;
                }
                ++i;
                ++n2;
            }
        } else if (this.portCombo.getItemCount() > 0) {
            this.portCombo.select(0);
        }
        if (!StringUtil.isEmpty((String)this.filterConfig)) {
            this.filterText.setText(this.filterConfig);
        }
    }

    public void saveSettings() {
        this.settings.setPortName(this.portCombo.getText());
        this.settings.setFilterText(this.filterText.getText().trim());
        this.settings.setProject(this.projectCombo.getText());
        this.dialogSettings.put("idf.monitor.project", this.projectCombo.getText());
        this.dialogSettings.put("cdtserial.portName", this.portCombo.getText());
        this.dialogSettings.put("idf.monitor.filter", this.filterText.getText().trim());
    }

    public boolean validateSettings() {
        return this.portCombo.getSelectionIndex() >= 0 || !this.portCombo.getText().isEmpty();
    }
}

