/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.tracing.heaptracing;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.ProjectDescriptionReader;
import com.espressif.idf.ui.tracing.Messages;
import com.espressif.idf.ui.tracing.TracingJsonParser;
import com.espressif.idf.ui.tracing.heaptracing.HeapTracingCallersViewComposite;
import com.espressif.idf.ui.tracing.heaptracing.HeapTracingDetailsComposite;
import com.espressif.idf.ui.tracing.heaptracing.HeapTracingOverviewComposite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

public class HeapTracingAnalysisEditor
extends MultiPageEditorPart {
    public static final String EDITOR_ID = "com.espressif.idf.ui.editor.heapTraceAnalysis";
    private IProject project;
    private IFile memoryDumpFile;
    private IFile elfSymbolsFile;
    private TracingJsonParser tracingJsonParser;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        FileEditorInput editorInput = (FileEditorInput)this.getEditorInput();
        this.memoryDumpFile = editorInput.getFile();
        this.project = this.memoryDumpFile.getProject();
        this.setPartName(this.project.getName());
        this.elfSymbolsFile = new ProjectDescriptionReader(this.project).getAppElfFile();
        try {
            this.tracingJsonParser = new TracingJsonParser(this.memoryDumpFile.getRawLocation().toOSString(), this.elfSymbolsFile);
        }
        catch (Exception execption) {
            Logger.log((Exception)execption);
        }
    }

    protected void createPages() {
        String osString = this.memoryDumpFile.getLocation().toOSString();
        Logger.log((String)("Editor input:" + osString));
        this.createOverviewPage();
        this.createDetailsPage();
        this.createCallersConsolidatedPage();
    }

    private void createCallersConsolidatedPage() {
        Composite parent = new Composite(this.getContainer(), 0);
        parent.setLayout((Layout)new FillLayout());
        HeapTracingCallersViewComposite tracingCallersViewComposite = new HeapTracingCallersViewComposite(this.tracingJsonParser);
        tracingCallersViewComposite.createPartControl(parent);
        int index = this.addPage((Control)parent);
        this.setPageText(index, Messages.TracingCallersConsolodiatedView_Tab);
    }

    private void createOverviewPage() {
        Composite parent = new Composite(this.getContainer(), 0);
        parent.setLayout((Layout)new FillLayout());
        HeapTracingOverviewComposite heapTracingOverviewComposite = new HeapTracingOverviewComposite(this.tracingJsonParser);
        heapTracingOverviewComposite.createPartControl(parent);
        int index = this.addPage((Control)parent);
        this.setPageText(index, Messages.TracingAnalysisEditor_OverviewTab);
    }

    private void createDetailsPage() {
        Composite parent = new Composite(this.getContainer(), 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        GridData layoutData = new GridData();
        layoutData.grabExcessVerticalSpace = true;
        layoutData.verticalAlignment = 4;
        Font font = parent.getFont();
        Composite tableComposite = new Composite(parent, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        GridData gridData = new GridData(1808);
        gridData.heightHint = 150;
        gridData.widthHint = 400;
        tableComposite.setLayout((Layout)layout);
        tableComposite.setLayoutData((Object)gridData);
        tableComposite.setFont(font);
        HeapTracingDetailsComposite tracingDetailsComposite = new HeapTracingDetailsComposite(this.tracingJsonParser);
        tracingDetailsComposite.createPartControl(tableComposite);
        int index = this.addPage((Control)parent);
        this.setPageText(index, "Details");
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }
}

