/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.tracing;

import com.espressif.idf.ui.tracing.AddressInfoVO;
import com.espressif.idf.ui.tracing.Messages;
import com.espressif.idf.ui.tracing.TracingUtil;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.part.ViewPart;

public class TracingCallersView
extends ViewPart {
    public static final String ID = "com.espressif.idf.ui.views.tracingcallersview";
    private List<AddressInfoVO> addressInfoVOs;
    private Tree tree;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.tree = new Tree(parent, 68352);
        this.tree.setHeaderVisible(true);
        this.tree.addSelectionListener((SelectionListener)new ItemSelectionListener());
        this.tree.setLinesVisible(true);
        this.createTreeColumns();
        this.refreshTable();
    }

    private void createTreeColumns() {
        TreeColumn colFileName = new TreeColumn(this.tree, 16384);
        colFileName.setWidth(200);
        colFileName.setText(Messages.TracingCallerView_ColFileName);
        TreeColumn colFunctionName = new TreeColumn(this.tree, 16384);
        colFunctionName.setWidth(200);
        colFunctionName.setText(Messages.TracingCallerView_ColFunctionName);
        TreeColumn colLineNumber = new TreeColumn(this.tree, 16384);
        colLineNumber.setWidth(100);
        colLineNumber.setText(Messages.TracingCallerView_ColLineNumber);
        TreeColumn colAddress = new TreeColumn(this.tree, 16384);
        colAddress.setText(Messages.TracingCallerView_ColAddress);
        colAddress.setWidth(100);
    }

    public void refreshTable() {
        if (this.addressInfoVOs == null || this.addressInfoVOs.isEmpty()) {
            return;
        }
        this.tree.removeAll();
        this.tree.setRedraw(false);
        TreeItem mainTreeItem = new TreeItem(this.tree, 0);
        AddressInfoVO mainAddressItem = this.addressInfoVOs.get(0);
        mainTreeItem.setData((Object)mainAddressItem);
        mainTreeItem.setText(0, mainAddressItem.getFile().getName());
        mainTreeItem.setText(1, mainAddressItem.getFunctionName());
        mainTreeItem.setText(2, String.valueOf(mainAddressItem.getLineNumber()));
        mainTreeItem.setText(3, mainAddressItem.getAddress());
        mainTreeItem.setExpanded(true);
        int i = 1;
        while (i < this.addressInfoVOs.size()) {
            TreeItem subTreeItem = new TreeItem(mainTreeItem, 0);
            AddressInfoVO subAddressItem = this.addressInfoVOs.get(i);
            subTreeItem.setData((Object)subAddressItem);
            subTreeItem.setText(0, subAddressItem.getFile().getName());
            subTreeItem.setText(1, subAddressItem.getFunctionName());
            subTreeItem.setText(2, String.valueOf(subAddressItem.getLineNumber()));
            subTreeItem.setText(3, subAddressItem.getAddress());
            subTreeItem.setExpanded(true);
            mainTreeItem = subTreeItem;
            ++i;
        }
        this.tree.setRedraw(true);
    }

    public void expandAll() {
        this.tree.setRedraw(false);
        TreeItem[] treeItemArray = this.tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            item.setExpanded(true);
            this.expandAllTreeItems(item);
            ++n2;
        }
        this.tree.setRedraw(true);
    }

    private void expandAllTreeItems(TreeItem item) {
        if (item.getItems() == null) {
            item.setExpanded(true);
        } else {
            TreeItem[] treeItemArray = item.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem subItem = treeItemArray[n2];
                this.expandAllTreeItems(subItem);
                subItem.setExpanded(true);
                ++n2;
            }
        }
    }

    public void setFocus() {
        if (this.tree != null) {
            this.tree.setFocus();
        }
    }

    public List<AddressInfoVO> getAddressInfoVOs() {
        return this.addressInfoVOs;
    }

    public void setAddressInfoVOs(List<AddressInfoVO> addressInfoVOs) {
        this.addressInfoVOs = addressInfoVOs;
    }

    private class ItemSelectionListener
    extends SelectionAdapter {
        private ItemSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TreeItem[] selection = TracingCallersView.this.tree.getSelection();
            AddressInfoVO addressInfoVO = (AddressInfoVO)selection[0].getData();
            TracingUtil.launchEditor(addressInfoVO.getFullFilePath());
            TracingUtil.goToLineNumber(addressInfoVO.getLineNumber());
        }
    }
}

