/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.tracing;

import com.espressif.idf.core.logging.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;

public class TclClient {
    private Socket clientSocket;
    private BufferedReader in;
    private BufferedWriter out;
    private static final int openOcdEOL = 26;

    public TclClient() {
        try {
            this.clientSocket = new Socket("localhost", 6666);
            this.in = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
            this.out = new BufferedWriter(new OutputStreamWriter(this.clientSocket.getOutputStream()));
        }
        catch (IOException e) {
            Logger.log((Exception)e);
        }
    }

    public void startTracing(String[] params) {
        Object startCommand = "esp apptrace start ";
        startCommand = (String)startCommand + String.join((CharSequence)" ", params);
        if (this.clientSocket.isConnected()) {
            try {
                this.out.write("capture \"" + (String)startCommand + "\"");
                this.out.write(26);
                this.out.flush();
            }
            catch (IOException e) {
                Logger.log((Exception)e);
            }
        }
    }

    public void stopTracing() {
        String stopCommand = "capture \"esp apptrace stop \"";
        if (this.clientSocket.isConnected()) {
            try {
                this.out.write(stopCommand);
                this.out.write(26);
                this.out.flush();
            }
            catch (IOException e) {
                Logger.log((Exception)e);
            }
        }
    }

    public BufferedReader getInBuffer() {
        return this.in;
    }
}

