/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.tools;

import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.toolchain.ESPToolChainManager;
import com.espressif.idf.core.tools.vo.IDFToolSet;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.LspService;
import com.espressif.idf.ui.tools.ToolsJob;
import com.espressif.idf.ui.update.ExportIDFTools;
import com.espressif.idf.ui.update.Messages;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.osgi.service.prefs.BackingStoreException;

public class ToolsActivationJob
extends ToolsJob {
    public static final String INSTALL_TOOLS_FLAG = "INSTALL_TOOLS_FLAG";

    public ToolsActivationJob(IDFToolSet idfToolSet, String pythonExecutablePath, String gitExecutablePath) {
        super("Tools Activation Job", null, null);
        this.idfToolSet = idfToolSet;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.idfToolSet == null) {
            return Status.error((String)"IDF Tool Set Cannot be null");
        }
        monitor.beginTask("Verifying if there are any changes to the installed tools", 5);
        monitor.worked(1);
        ExportIDFTools exportIDFTools = new ExportIDFTools();
        IStatus status = exportIDFTools.getToolsExportOutputFromGivenIdfPath(this.idfToolSet.getSystemPythonExecutablePath(), this.idfToolSet.getSystemGitExecutablePath(), this.console, this.errorConsoleStream, this.idfToolSet.getIdfLocation());
        if (status.getSeverity() == 4) {
            return Status.error((String)"INSTALL_AGAIN");
        }
        monitor.worked(1);
        monitor.setTaskName("Exporting variables to eclipse");
        this.processExportCmdOutput(status.getMessage());
        this.setEnvVarsInEclipse();
        monitor.worked(1);
        monitor.setTaskName("Setting up toolchains and targets");
        this.setUpToolChainsAndTargets();
        monitor.worked(1);
        monitor.setTaskName(Messages.InstallToolsHandler_InstallingWebscoketMsg);
        this.handleWebSocketClientInstall();
        monitor.worked(1);
        monitor.setTaskName("Setting OpenOCD rules");
        this.copyOpenOcdRules();
        monitor.worked(1);
        this.idfToolSet.setActive(true);
        this.toolSetConfigurationManager.export(this.idfToolSet);
        this.console.println("Tools Activated");
        new LspService().updateClangdPath();
        IEclipsePreferences scopedPreferenceStore = InstanceScope.INSTANCE.getNode("com.espressif.idf.ui");
        scopedPreferenceStore.putBoolean(INSTALL_TOOLS_FLAG, true);
        try {
            scopedPreferenceStore.flush();
        }
        catch (BackingStoreException e) {
            Logger.log((Exception)((Object)e));
        }
        return Status.OK_STATUS;
    }

    private void copyOpenOcdRules() {
        if (Platform.getOS().equals("linux") && !IDFUtil.getOpenOCDLocation().equalsIgnoreCase("")) {
            this.console.println(Messages.InstallToolsHandler_CopyingOpenOCDRules);
            StringBuilder pathToRules = new StringBuilder();
            pathToRules.append(IDFUtil.getOpenOCDLocation());
            pathToRules.append("/../share/openocd/contrib/60-openocd.rules");
            File rulesFile = new File(pathToRules.toString());
            if (rulesFile.exists()) {
                final Path source = Paths.get(pathToRules.toString(), new String[0]);
                final Path target = Paths.get("/etc/udev/rules.d/60-openocd.rules", new String[0]);
                this.console.println(String.format(Messages.InstallToolsHandler_OpenOCDRulesCopyPaths, source.toString(), target.toString()));
                Display.getDefault().syncExec(new Runnable(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void run() {
                        try {
                            if (target.toFile().exists()) {
                                MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), 200);
                                messageBox.setText(Messages.InstallToolsHandler_OpenOCDRulesCopyWarning);
                                messageBox.setMessage(Messages.InstallToolsHandler_OpenOCDRulesCopyWarningMessage);
                                int response = messageBox.open();
                                if (response != 64) {
                                    ToolsActivationJob.this.console.println(Messages.InstallToolsHandler_OpenOCDRulesNotCopied);
                                    return;
                                }
                                Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
                            } else {
                                Files.copy(source, target, new CopyOption[0]);
                            }
                            ToolsActivationJob.this.console.println(Messages.InstallToolsHandler_OpenOCDRulesCopied);
                            return;
                        }
                        catch (IOException e) {
                            Logger.log((Exception)e);
                            ToolsActivationJob.this.errorConsoleStream.println(Messages.InstallToolsHandler_OpenOCDRulesCopyError);
                        }
                    }
                });
            }
        }
    }

    private void setUpToolChainsAndTargets() {
        IStatus status = this.loadTargetsAvailableFromIdfInCurrentToolSet();
        if (status.getSeverity() == 4) {
            Logger.log((String)"Unable to get IDF targets from current toolset");
            return;
        }
        List<String> targets = this.extractTargets(status.getMessage());
        ESPToolChainManager espToolChainManager = new ESPToolChainManager();
        espToolChainManager.removeLaunchTargetsNotPresent(targets);
        espToolChainManager.removeCmakeToolChains();
        espToolChainManager.removeStdToolChains();
        espToolChainManager.configureToolChain(targets);
    }

    private void setEnvVarsInEclipse() {
        if (this.idfToolSet == null) {
            throw new RuntimeException("Tools Cannot be null");
        }
        IDFEnvironmentVariables idfEnvironmentVariables = new IDFEnvironmentVariables();
        idfEnvironmentVariables.removeAllEnvVariables();
        this.idfToolSet.getEnvVars().forEach((key, value) -> {
            if (value != null) {
                idfEnvironmentVariables.addEnvVariable(key, value);
            }
        });
        String path = this.replacePathVariable((String)this.idfToolSet.getEnvVars().get("PATH"));
        idfEnvironmentVariables.addEnvVariable("IDF_PATH", this.idfToolSet.getIdfLocation());
        idfEnvironmentVariables.addEnvVariable("PATH", path);
        idfEnvironmentVariables.addEnvVariable("PYTHON_EXE_PATH", this.idfToolSet.getSystemPythonExecutablePath());
        idfEnvironmentVariables.addEnvVariable("IDF_COMPONENT_MANAGER", "1");
        idfEnvironmentVariables.addEnvVariable("IDF_MAINTAINER", "1");
        IDFUtil.updateEspressifPrefPageOpenocdPath();
    }
}

