/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.tools;

import java.text.MessageFormat;
import java.time.Duration;
import java.util.Queue;
import org.eclipse.jgit.lib.BatchingProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ProgressBar;

public class GitWizardRepProgressMonitor
extends BatchingProgressMonitor {
    private Queue<String> logMessages;
    private boolean jobCancelled;
    private ProgressBar progressBar;
    private Display display;

    public GitWizardRepProgressMonitor(Queue<String> logMessages, ProgressBar progressBar) {
        this.logMessages = logMessages;
        this.progressBar = progressBar;
        this.display = progressBar.getDisplay();
    }

    protected void onUpdate(String taskName, int workCurr) {
        this.onUpdate(taskName, workCurr, null);
    }

    protected void onEndTask(String taskName, int workCurr) {
        this.onEndTask(taskName, workCurr, null);
    }

    protected void onUpdate(String taskName, int workCurr, int workTotal, int percentDone) {
        this.onUpdate(taskName, workCurr, null);
    }

    protected void onEndTask(String taskName, int workCurr, int workTotal, int percentDone) {
        this.onEndTask(taskName, workCurr, workTotal, percentDone, null);
    }

    protected void onUpdate(String taskName, int workCurr, Duration duration) {
        this.updateProgressBar(workCurr);
        this.setProgressBarVisibility(false);
        this.logMessages.add(MessageFormat.format("{0}  {1}", taskName, workCurr));
    }

    protected void onEndTask(String taskName, int workCurr, Duration duration) {
        this.updateProgressBar(workCurr);
        this.logMessages.add(MessageFormat.format("Finished {0}  {1}", taskName, workCurr));
    }

    protected void onUpdate(String taskName, int workCurr, int workTotal, int percentDone, Duration duration) {
        this.initializeMaxProgressbar(workTotal);
        this.updateProgressBar(workCurr);
        this.logMessages.add(MessageFormat.format("{0} {1}, total {2} {3}% Completed", taskName, workCurr, workTotal, percentDone));
    }

    protected void onEndTask(String taskName, int workCurr, int workTotal, int percentDone, Duration duration) {
        this.initializeMaxProgressbar(workTotal);
        this.updateProgressBar(workCurr);
        this.setProgressBarVisibility(false);
        this.logMessages.add(MessageFormat.format("Finished {0} {1}, total {2} {3}% Completed", taskName, workCurr, workTotal, percentDone));
    }

    public boolean isCancelled() {
        if (this.jobCancelled) {
            this.logMessages.add("Cancelled by User");
        }
        return this.jobCancelled;
    }

    public void setJobCancelled(boolean jobCancelled) {
        this.jobCancelled = jobCancelled;
    }

    private void initializeMaxProgressbar(final int max) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                GitWizardRepProgressMonitor.this.progressBar.setVisible(true);
                GitWizardRepProgressMonitor.this.progressBar.setMaximum(max);
            }
        });
    }

    private void updateProgressBar(final int updateValue) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                GitWizardRepProgressMonitor.this.progressBar.setSelection(updateValue);
            }
        });
    }

    private void setProgressBarVisibility(final boolean visible) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                GitWizardRepProgressMonitor.this.progressBar.setVisible(visible);
            }
        });
    }
}

