/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.templates;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.logging.Logger;
import java.net.MalformedURLException;
import java.net.URL;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class FormBrowser {
    FormToolkit toolkit;
    Composite container;
    Browser formText;
    String text;
    int style;

    public FormBrowser(int style) {
        this.style = style;
    }

    public void createControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        int borderStyle = this.toolkit.getBorderStyle() == 2048 ? 0 : 2048;
        this.container = new Composite(parent, borderStyle);
        FillLayout flayout = new FillLayout();
        flayout.marginWidth = 1;
        flayout.marginHeight = 1;
        this.container.setLayout((Layout)flayout);
        this.formText = new Browser(this.container, 0);
        this.formText.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                try {
                    PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(event.location));
                    event.doit = false;
                }
                catch (MalformedURLException | PartInitException throwable) {
                    // empty catch block
                }
            }

            public void changed(LocationEvent event) {
            }
        });
        if (borderStyle == 0) {
            this.formText.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
            this.toolkit.paintBordersFor(this.container);
        }
        FormText ftext = this.toolkit.createFormText((Composite)this.formText, false);
        this.formText.setBackground(this.toolkit.getColors().getBackground());
        this.formText.setForeground(this.toolkit.getColors().getForeground());
        ftext.marginWidth = 2;
        ftext.marginHeight = 2;
        ftext.setHyperlinkSettings((HyperlinkSettings)this.toolkit.getHyperlinkGroup());
        this.formText.addDisposeListener(e -> {
            if (this.toolkit != null) {
                this.toolkit.dispose();
                this.toolkit = null;
            }
        });
        if (this.text != null) {
            this.formText.setText(this.text);
        }
    }

    public Control getControl() {
        return this.container;
    }

    public void setText(String text) {
        if (this.formText != null) {
            try {
                this.text = this.convertMarkdownToHtml(text);
                this.formText.setText(this.text);
            }
            catch (Exception e) {
                Status status = new Status(4, "com.espressif.idf.core", "Error parsing the template description", (Throwable)e);
                IDFCorePlugin.getPlugin().getLog().log((IStatus)status);
            }
        }
    }

    private String convertMarkdownToHtml(String markdownText) {
        try {
            Parser parser = Parser.builder().build();
            Node document = parser.parse(markdownText);
            HtmlRenderer renderer = HtmlRenderer.builder().build();
            return renderer.render(document);
        }
        catch (Exception e) {
            Logger.log((Exception)e);
            return markdownText;
        }
    }
}

