/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.size;

import com.espressif.idf.core.util.IDFUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Version;

public class IDFSizeConstants {
    public static String LAYOUT = "layout";
    public static String NAME = "name";
    public static String USED = "used";
    public static String FREE = "free";
    public static String DATA = "data";
    public static String BSS = "bss";
    public static String IRAM = "iram";
    public static String DIRAM = "diram";
    public static String FLASH_TEXT = "flash_text";
    public static String FLASH_RODATA = "flash_rodata";
    public static String OTHER = "other";
    public static String TOTAL = "total";
    public static String FLASH_RODATA_OVERVIEW = "flash_rodata";
    public static String DRAM_DATA = "dram_data";
    public static String DRAM_BSS = "dram_bss";
    public static String FLASH_CODE = "flash_code";
    public static String TOTAL_SIZE = "total_size";
    public static String USED_IRAM = "used_iram";
    public static String AVAILABLE_IRAM = "available_iram";
    public static String USED_IRAM_RATIO = "used_iram_ratio";
    public static String USED_DRAM = "used_dram";
    public static String AVAILABLE_DRAM = "available_dram";
    public static String USED_DRAM_RATIO = "used_dram_ratio";
    public static String USED_DIRAM = "used_diram";
    public static String AVAILABLE_DIRAM = "available_diram";
    public static String USED_DIRAM_RATIO = "used_diram_ratio";

    static {
        String version = IDFUtil.getEspIdfVersion();
        String regexToFindVersion = "v([0-9][.0-9]+)";
        String oldIdfSizeConstantsVersion = "4.3.1";
        Pattern p = Pattern.compile("v([0-9][.0-9]+)");
        Matcher m = p.matcher(version);
        if (m.find() && new Version("4.3.1").compareTo(new Version(m.group(1).replaceAll("-.*", ".0"))) < 0) {
            FLASH_RODATA_OVERVIEW = "flash_rodata";
            DATA = ".dram0.data";
            BSS = ".dram0.bss";
            IRAM = ".iram0.text";
            DIRAM = "diram";
            FLASH_TEXT = ".flash.text";
            FLASH_RODATA = ".flash.rodata";
            OTHER = "ram_st_total";
            TOTAL = "flash_total";
            DRAM_DATA = "dram_data";
            DRAM_BSS = "dram_bss";
            FLASH_CODE = "flash_code";
            TOTAL_SIZE = "total_size";
            USED_IRAM = "used_iram";
            AVAILABLE_IRAM = "iram_remain";
            USED_IRAM_RATIO = "used_iram_ratio";
            USED_DRAM = "used_dram";
            AVAILABLE_DRAM = "dram_remain";
            USED_DRAM_RATIO = "used_dram_ratio";
            USED_DIRAM = "used_diram";
            AVAILABLE_DIRAM = "diram_remain";
            USED_DIRAM_RATIO = "used_diram_ratio";
        }
    }
}

