/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.installcomponents.handler;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.ProcessBuilderFactory;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.ui.IDFConsole;
import com.espressif.idf.ui.handlers.NewProjectHandlerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class InstallCommandHandler {
    private static final String ADD_DEPENDENCY_COMMAND = "add-dependency";
    private static final String EQUALITY = "==";
    private static final String ASTERIK = "*";
    private static final String FORWARD_SLASH = "/";
    private String name;
    private String namespace;
    private String version;
    private IProject project;

    public InstallCommandHandler(String name, String namespace, String version, IProject project) {
        this.name = name;
        this.namespace = namespace;
        this.version = version;
        this.project = project;
    }

    public void executeInstallCommand() throws Exception {
        if (!NewProjectHandlerUtil.installToolsCheck()) {
            return;
        }
        IDFEnvironmentVariables idfEnvironmentVariables = new IDFEnvironmentVariables();
        idfEnvironmentVariables.addEnvVariable("IDF_COMPONENT_MANAGER", "1");
        final Map envMap = new IDFEnvironmentVariables().getSystemEnvMap();
        final Path pathToProject = new Path(this.project.getLocation().toString());
        final ArrayList<String> commands = new ArrayList<String>();
        commands.add(IDFUtil.getIDFPythonEnvPath());
        commands.add(IDFUtil.getIDFPythonScriptFile().getAbsolutePath());
        Job job = new Job("Install Components Job"){

            protected IStatus run(IProgressMonitor monitor) {
                commands.add(InstallCommandHandler.ADD_DEPENDENCY_COMMAND);
                if (StringUtil.isEmpty((String)InstallCommandHandler.this.version)) {
                    commands.add(InstallCommandHandler.this.namespace.concat(InstallCommandHandler.FORWARD_SLASH).concat(InstallCommandHandler.this.name.concat(InstallCommandHandler.ASTERIK)));
                } else {
                    commands.add(InstallCommandHandler.this.namespace.concat(InstallCommandHandler.FORWARD_SLASH).concat(InstallCommandHandler.this.name.concat(InstallCommandHandler.EQUALITY).concat(InstallCommandHandler.this.version)));
                }
                new IDFConsole().getConsoleStream().print(InstallCommandHandler.this.runCommand(commands, pathToProject, envMap));
                try {
                    InstallCommandHandler.this.project.refreshLocal(2, null);
                }
                catch (CoreException e) {
                    Logger.log((Exception)((Object)e));
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private String runCommand(List<String> arguments, Path workDir, Map<String, String> env) {
        String exportCmdOp = "";
        ProcessBuilderFactory processRunner = new ProcessBuilderFactory();
        try {
            IStatus status = processRunner.runInBackground(arguments, (IPath)workDir, env);
            if (status == null) {
                Logger.log((Plugin)IDFCorePlugin.getPlugin(), (IStatus)IDFCorePlugin.errorStatus((String)"Status can't be null", null));
                return IDFCorePlugin.errorStatus((String)"Status can't be null", null).toString();
            }
            exportCmdOp = status.getMessage();
            Logger.log((String)exportCmdOp);
        }
        catch (Exception e1) {
            Logger.log((Plugin)IDFCorePlugin.getPlugin(), (Exception)e1);
        }
        return exportCmdOp;
    }
}

