/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.install;

import com.espressif.idf.core.IDFVersion;
import com.espressif.idf.core.ZipUtility;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.tools.ToolSetConfigurationManager;
import com.espressif.idf.core.tools.vo.IDFToolSet;
import com.espressif.idf.ui.install.GitRepositoryBuilder;
import com.espressif.idf.ui.install.IDFDownloadPage;
import com.espressif.idf.ui.install.Messages;
import com.espressif.idf.ui.tools.ToolsActivationJob;
import com.espressif.idf.ui.tools.ToolsActivationJobListener;
import com.espressif.idf.ui.tools.ToolsInstallationJob;
import com.espressif.idf.ui.tools.manager.pages.ESPIDFMainTablePage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class IDFNewToolsWizard
extends Wizard {
    private static final int BUFFER_SIZE = 4096;
    private IDFDownloadPage downloadPage;
    private ESPIDFMainTablePage espidfMainTablePage;
    private ToolSetConfigurationManager toolSetConfigurationManager;
    private ToolsInstallationJob toolsInstallationJob;
    private String pythonPath;
    private String gitPath;

    public IDFNewToolsWizard() {
    }

    public IDFNewToolsWizard(ESPIDFMainTablePage espidfMainTablePage) {
        this.espidfMainTablePage = espidfMainTablePage;
        this.toolSetConfigurationManager = new ToolSetConfigurationManager();
    }

    public boolean performFinish() {
        final IDFVersion version = this.downloadPage.Version();
        final String destinationLocation = this.downloadPage.getDestinationLocation();
        boolean configureExistingEnabled = this.downloadPage.isConfigureExistingEnabled();
        this.pythonPath = this.downloadPage.getPythonExePath();
        this.gitPath = this.downloadPage.getGitExecutablePath();
        if (configureExistingEnabled) {
            String localIdfLocation = this.downloadPage.getExistingIDFLocation();
            this.toolsInstallationJob = new ToolsInstallationJob(this.pythonPath, this.gitPath, localIdfLocation);
            this.toolsInstallationJob.addJobChangeListener((IJobChangeListener)new ToolsInstallationJobChangeListener());
            this.toolsInstallationJob.schedule();
        } else {
            new File(destinationLocation).mkdirs();
            final String url = version.getUrl();
            if (version.getName().equals("master") || version.getName().startsWith("release/")) {
                Job job = new Job(MessageFormat.format(Messages.IDFDownloadWizard_CloningJobMsg, version.getName())){

                    protected IStatus run(IProgressMonitor monitor) {
                        String localIdfLocation = IDFNewToolsWizard.this.repositoryClone(version.getName(), url, destinationLocation, monitor);
                        IDFNewToolsWizard.this.toolsInstallationJob = new ToolsInstallationJob(IDFNewToolsWizard.this.pythonPath, IDFNewToolsWizard.this.gitPath, localIdfLocation);
                        IDFNewToolsWizard.this.toolsInstallationJob.addJobChangeListener((IJobChangeListener)new ToolsInstallationJobChangeListener());
                        IDFNewToolsWizard.this.toolsInstallationJob.schedule();
                        return Status.OK_STATUS;
                    }
                };
                job.setUser(true);
                job.schedule();
            } else {
                Job job = new Job(MessageFormat.format(Messages.IDFDownloadWizard_DownloadingJobMsg, version.getName())){

                    protected IStatus run(IProgressMonitor monitor) {
                        String localIdfLocation = IDFNewToolsWizard.this.download(monitor, url, destinationLocation);
                        IDFNewToolsWizard.this.toolsInstallationJob = new ToolsInstallationJob(IDFNewToolsWizard.this.pythonPath, IDFNewToolsWizard.this.gitPath, localIdfLocation);
                        IDFNewToolsWizard.this.toolsInstallationJob.addJobChangeListener((IJobChangeListener)new ToolsInstallationJobChangeListener());
                        IDFNewToolsWizard.this.toolsInstallationJob.schedule();
                        return Status.OK_STATUS;
                    }
                };
                job.setUser(true);
                job.schedule();
            }
            this.openProgressView();
        }
        return true;
    }

    private void openProgressView() {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.ProgressView");
        }
        catch (PartInitException e) {
            Logger.log((Exception)((Object)e));
        }
    }

    protected String download(IProgressMonitor monitor, String url, String destinationLocation) {
        try {
            String downloadFile = this.downloadFile(url, destinationLocation, monitor);
            if (downloadFile != null) {
                this.unZipFile(downloadFile, destinationLocation);
                new File(downloadFile).delete();
                String folderName = new File(url).getName().replace(".zip", "");
                return new File(destinationLocation, folderName).getAbsolutePath();
            }
        }
        catch (IOException e) {
            Logger.log((Exception)e);
            this.showErrorMessage(e.getLocalizedMessage());
        }
        return "";
    }

    protected String repositoryClone(String version, String url, String destinationLocation, IProgressMonitor monitor) {
        GitRepositoryBuilder gitBuilder = new GitRepositoryBuilder(false, null);
        StringBuilder destinationLocationPath = new StringBuilder();
        destinationLocationPath.append(destinationLocation);
        destinationLocationPath.append("/esp-idf-");
        if (version.startsWith("release/")) {
            destinationLocationPath.append(version.substring("release/".length()));
        } else {
            destinationLocationPath.append(version);
        }
        gitBuilder.repositoryURI(url);
        gitBuilder.repositoryDirectory(new File(destinationLocationPath.toString()));
        gitBuilder.activeBranch(version);
        gitBuilder.setProgressMonitor(monitor);
        try {
            gitBuilder.repositoryClone();
            return destinationLocationPath.toString();
        }
        catch (Exception e) {
            Logger.log((Exception)e);
            this.showErrorMessage(e.getLocalizedMessage());
            return "";
        }
    }

    private void unZipFile(String downloadFile, String destinationLocation) {
        new ZipUtility().decompress(new File(downloadFile), new File(destinationLocation));
    }

    private void showErrorMessage(final String errorMessage) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.IDFDownloadWizard_ErrorTitle, (String)errorMessage);
            }
        });
    }

    public void init(IWorkbench aWorkbench, IStructuredSelection currentSelection) {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.downloadPage = new IDFDownloadPage("Download page");
        this.addPage((IWizardPage)this.downloadPage);
    }

    protected String downloadFile(String fileURL, String saveDir, IProgressMonitor monitor) throws IOException {
        String msg = MessageFormat.format(Messages.IDFDownloadWizard_DownloadingMessage, fileURL);
        Logger.log((String)msg);
        monitor.beginTask(msg, 100);
        URL url = new URL(fileURL);
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        int responseCode = httpConn.getResponseCode();
        if (responseCode == 200) {
            String fileName = "";
            String disposition = httpConn.getHeaderField("Content-Disposition");
            String contentType = httpConn.getContentType();
            int contentLength = httpConn.getContentLength();
            if (disposition != null) {
                String identifier = "filename=";
                int index = disposition.indexOf(identifier);
                if (index > 0) {
                    fileName = disposition.substring(index + identifier.length(), disposition.length());
                }
            } else {
                fileName = fileURL.substring(fileURL.lastIndexOf("/") + 1, fileURL.length());
            }
            Logger.log((String)("Content-Type = " + contentType));
            Logger.log((String)("Content-Disposition = " + disposition));
            Logger.log((String)("Content-Length = " + contentLength));
            Logger.log((String)("fileName = " + fileName));
            InputStream inputStream = httpConn.getInputStream();
            String saveFilePath = saveDir + File.separator + fileName;
            FileOutputStream outputStream = new FileOutputStream(saveFilePath);
            float downloaded = 0.0f;
            int bytesRead = -1;
            int noOfUnitedUpdated = 0;
            byte[] buffer = new byte[4096];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
                int unitsDownloadedSofar = (int)((downloaded += 4096.0f) / (float)contentLength * 100.0f);
                if (unitsDownloadedSofar > noOfUnitedUpdated) {
                    int needToBeUpdated = unitsDownloadedSofar - noOfUnitedUpdated;
                    noOfUnitedUpdated += needToBeUpdated;
                    String taskName = MessageFormat.format(msg + "({0}/{1})", this.convertToMB(downloaded), this.convertToMB(contentLength));
                    monitor.setTaskName(taskName);
                    monitor.worked(needToBeUpdated);
                }
                if (!monitor.isCanceled()) continue;
                Logger.log((String)"File download cancelled");
                saveFilePath = null;
                break;
            }
            outputStream.close();
            inputStream.close();
            return saveFilePath;
        }
        Logger.log((String)("No file to download. Server replied HTTP code: " + responseCode));
        httpConn.disconnect();
        return null;
    }

    protected String convertToMB(float value) {
        return String.format("%.2f", Float.valueOf(value / 1048576.0f)) + " MB";
    }

    private class ToolsInstallationJobChangeListener
    extends JobChangeAdapter {
        private ToolsInstallationJobChangeListener() {
        }

        public void done(IJobChangeEvent event) {
            List idfToolSets = IDFNewToolsWizard.this.toolSetConfigurationManager.getIdfToolSets(false);
            Display.getDefault().asyncExec(() -> {
                if (IDFNewToolsWizard.this.espidfMainTablePage != null) {
                    IDFNewToolsWizard.this.espidfMainTablePage.refreshEditorUI();
                }
            });
            if (idfToolSets != null && idfToolSets.size() == 1) {
                ToolsActivationJob toolsActivationJob = new ToolsActivationJob((IDFToolSet)idfToolSets.get(0), IDFNewToolsWizard.this.pythonPath, IDFNewToolsWizard.this.gitPath);
                ToolsActivationJobListener toolsActivationJobListener = new ToolsActivationJobListener(IDFNewToolsWizard.this.espidfMainTablePage);
                toolsActivationJob.addJobChangeListener((IJobChangeListener)toolsActivationJobListener);
                toolsActivationJob.schedule();
            }
        }
    }
}

