/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.install;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.ui.install.GitProgressMonitor;
import com.espressif.idf.ui.install.Messages;
import com.espressif.idf.ui.tools.GitWizardRepProgressMonitor;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.ProgressMonitor;

public class GitRepositoryBuilder {
    private File repositoryDirectory;
    private String activeBranch;
    private String uri;
    private IProgressMonitor monitor;
    private boolean fromWizard;
    private GitWizardRepProgressMonitor gitWizardRepProgressMonitor;

    public GitRepositoryBuilder(boolean fromWizard, GitWizardRepProgressMonitor gitWizardRepProgressMonitor) {
        this.fromWizard = fromWizard;
        this.gitWizardRepProgressMonitor = gitWizardRepProgressMonitor;
    }

    public void repositoryDirectory(File directory) {
        this.repositoryDirectory = directory;
    }

    public void activeBranch(String value) {
        this.activeBranch = value;
    }

    public void repositoryClone() throws Exception {
        ArrayList<String> branchesToClone = new ArrayList<String>();
        branchesToClone.add(this.getBranchPath(this.activeBranch));
        GitProgressMonitor gitProgressMonitor = new GitProgressMonitor(this.monitor);
        Git git = ((CloneCommand)Git.cloneRepository().setProgressMonitor((ProgressMonitor)(this.fromWizard ? this.gitWizardRepProgressMonitor : gitProgressMonitor)).setCloneSubmodules(true).setURI(this.uri).setDirectory(this.repositoryDirectory).setBranchesToClone(branchesToClone).setBranch(this.getBranchPath(this.activeBranch)).setTimeout(300)).call();
        Logger.log((String)String.format(Messages.GitRepositoryBuilder_gitClone, git.toString()));
        git.getRepository().close();
        Logger.log((String)MessageFormat.format("ESP-IDF {0} cloning completed!", this.activeBranch));
    }

    private String getBranchPath(String branchName) {
        return "refs/heads/" + branchName;
    }

    public void repositoryURI(String uri) {
        this.uri = uri;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }
}

