/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.handlers;

import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.ui.EclipseUtil;
import com.espressif.idf.ui.handlers.Messages;
import com.espressif.idf.ui.handlers.NewProjectHandlerUtil;
import com.espressif.idf.ui.update.AbstractToolsHandler;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;

public class ProjectCleanCommandHandler
extends AbstractToolsHandler {
    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.activateIDFConsoleView();
        if (!NewProjectHandlerUtil.installToolsCheck()) {
            return null;
        }
        IProject selectedProject = EclipseUtil.getSelectedProjectInExplorer();
        Path pathToProject = new Path(selectedProject.getLocation().toString());
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(IDFUtil.getIDFPythonEnvPath());
        commands.add(IDFUtil.getIDFPythonScriptFile().getAbsolutePath());
        commands.add("-B");
        try {
            commands.add(IDFUtil.getBuildDir((IProject)selectedProject));
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        commands.add("clean");
        Map envMap = new IDFEnvironmentVariables().getSystemEnvMap();
        this.runCommandInNewJob(Messages.ProjectCleanCommandHandler_RunningProjectCleanJobName, commands, pathToProject, envMap);
        return event;
    }

    @Override
    protected void execute() {
    }
}

