/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.handlers;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.ClangdConfigFileHandler;
import com.espressif.idf.ui.handlers.EclipseHandler;
import com.espressif.idf.ui.handlers.Messages;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ClangdConfigCreateHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IProject project = EclipseHandler.getSelectedProject("org.eclipse.ui.navigator.ProjectExplorer");
        if (project == null) {
            project = EclipseHandler.getSelectedResource((IEvaluationContext)event.getApplicationContext());
        }
        if (project == null) {
            throw new ExecutionException(Messages.ClangdConfigCreateHandler_NoProjectFound);
        }
        this.updateClangdFile(project);
        return null;
    }

    private void updateClangdFile(IProject project) {
        try {
            new ClangdConfigFileHandler().update(project);
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.ClangdConfigCreateHandler_MsgTitle, (String)Messages.ClangdConfigCreateHandler_FileCreationMsg);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.ClangdConfigCreateHandler_Error, (String)(Messages.ClangdConfigCreateHandler_FailedToCreate + e.getMessage()));
            Logger.log((Exception)e);
        }
    }
}

