/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui;

import com.espressif.idf.core.logging.Logger;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class IDFConsole {
    private MessageConsole messageConsole;

    public MessageConsoleStream getConsoleStream() {
        return this.getConsoleStream("ESP-IDF Console", null, false);
    }

    public MessageConsoleStream getConsoleStream(String consoleName, URL imageUrl, final boolean errorStream, boolean handleControlChars) {
        MessageConsole msgConsole = this.findConsole(consoleName, imageUrl);
        msgConsole.setHandleControlCharacters(handleControlChars);
        msgConsole.setCarriageReturnAsControlCharacter(handleControlChars);
        msgConsole.clearConsole();
        final MessageConsoleStream console = msgConsole.newMessageStream();
        msgConsole.activate();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IDFConsole.this.openConsoleView();
                if (errorStream) {
                    console.setColor(new Color(255, 0, 0));
                }
            }
        });
        return console;
    }

    public MessageConsoleStream getConsoleStream(String consoleName, URL imageUrl, boolean errorStream) {
        return this.getConsoleStream(consoleName, imageUrl, errorStream, false);
    }

    private MessageConsole findConsole(String name, URL imageURL) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(name, ImageDescriptor.createFromURL((URL)imageURL));
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    protected void openConsoleView() {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.console.ConsoleView");
        }
        catch (PartInitException e) {
            Logger.log((Exception)((Object)e));
        }
    }
}

