/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.internal.debug.gdbjtag.ui.preferences;

import java.math.BigInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.ui.memory.AbstractTableRendering;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingSynchronizationService;
import org.eclipse.embedcdt.debug.gdbjtag.core.memory.PeripheralMemoryBlockExtension;
import org.eclipse.embedcdt.debug.gdbjtag.core.viewmodel.peripheral.PeripheralClusterArrayVMNode;
import org.eclipse.embedcdt.debug.gdbjtag.core.viewmodel.peripheral.PeripheralGroupVMNode;
import org.eclipse.embedcdt.debug.gdbjtag.core.viewmodel.peripheral.PeripheralRegisterArrayVMNode;
import org.eclipse.embedcdt.debug.gdbjtag.core.viewmodel.peripheral.PeripheralRegisterVMNode;
import org.eclipse.embedcdt.debug.gdbjtag.ui.render.peripheral.ILinkToolTipListener;
import org.eclipse.embedcdt.debug.gdbjtag.ui.render.peripheral.LinkToolTip;
import org.eclipse.embedcdt.debug.gdbjtag.ui.render.peripheral.PeripheralColumnInfo;
import org.eclipse.embedcdt.debug.gdbjtag.ui.render.peripheral.PeripheralContentProvider;
import org.eclipse.embedcdt.debug.gdbjtag.ui.render.peripheral.PeripheralEditingSupport;
import org.eclipse.embedcdt.debug.gdbjtag.ui.render.peripheral.PeripheralFilterDialog;
import org.eclipse.embedcdt.debug.gdbjtag.ui.render.peripheral.PeripheralNameFilter;
import org.eclipse.embedcdt.debug.gdbjtag.ui.render.peripheral.PeripheralViewerComparator;
import org.eclipse.embedcdt.internal.debug.gdbjtag.ui.Activator;
import org.eclipse.embedcdt.internal.debug.gdbjtag.ui.render.peripheral.PeripheralColumnLabelProvider;
import org.eclipse.embedcdt.ui.SystemUIJob;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.PluginActionContributionItem;

public class PeripheralRendering
extends AbstractTableRendering
implements IMemoryRendering,
IDebugEventSetListener,
IPropertyChangeListener,
ILinkToolTipListener {
    public static final String ID = "org.eclipse.embedcdt.internal.debug.gdbjtag.ui.memoryRendering";
    private static final PeripheralColumnInfo[] fgColumnInfo = new PeripheralColumnInfo[]{new PeripheralColumnInfo("Register", 4, PeripheralColumnInfo.ColumnType.REGISTER, true), new PeripheralColumnInfo("Address", 2, PeripheralColumnInfo.ColumnType.ADDRESS, true), new PeripheralColumnInfo("Value", 2, PeripheralColumnInfo.ColumnType.VALUE, false)};
    private SystemUIJob fRefreshJob = new SystemUIJob(String.valueOf(String.valueOf(this.getClass().getSimpleName())) + "#refresh"){

        public IStatus runInUIThread(IProgressMonitor pm) {
            if (!PeripheralRendering.this.fPeripheralViewer.getTree().isDisposed()) {
                PeripheralRendering.this.refresh();
            }
            return Status.OK_STATUS;
        }
    };
    private Action fAddFilterAction;
    private Action fRemoveFilterAction;
    private TreeViewer fPeripheralViewer;
    private String fRenderingId;
    private Action fRefreshMenuAction;
    private Action fCollapseRegistersAction;
    private Action fShowFieldsAction;
    private Action fForceReadAction;
    private PeripheralMemoryBlockExtension fMemoryBlock;
    private IMemoryRenderingContainer fContainer;
    private PeripheralViewerComparator fComparator;

    public PeripheralRendering(String renderingId) {
        super(renderingId);
        this.fRefreshJob.setPriority(10);
        this.fAddFilterAction = null;
        this.fRemoveFilterAction = null;
        this.fRefreshMenuAction = null;
        this.fCollapseRegistersAction = null;
        this.fShowFieldsAction = null;
        this.fForceReadAction = null;
        this.fRenderingId = renderingId;
    }

    public void init(IMemoryRenderingContainer container, IMemoryBlock block) {
        super.init(container, block);
        this.fContainer = container;
        if (block instanceof PeripheralMemoryBlockExtension) {
            this.fMemoryBlock = (PeripheralMemoryBlockExtension)block;
        }
    }

    public void dispose() {
        this.removeDebugEventListener();
    }

    public Object getAdapter(Class clazz) {
        return super.getAdapter(clazz);
    }

    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        this.fPeripheralViewer = new TreeViewer(composite, 66304);
        Control control = this.fPeripheralViewer.getControl();
        TreeColumnLayout treeColumnLayout = new TreeColumnLayout();
        composite.setLayout((Layout)treeColumnLayout);
        control.setLayoutData((Object)new GridData(1808));
        this.fPeripheralViewer.setAutoExpandLevel(-1);
        Tree tree = this.fPeripheralViewer.getTree();
        this.fPeripheralViewer.setContentProvider((IContentProvider)new PeripheralContentProvider(this.fMemoryBlock.getPeripheralRegisterGroup()));
        this.fComparator = new PeripheralViewerComparator();
        this.fPeripheralViewer.setComparator((ViewerComparator)this.fComparator);
        LinkToolTip.enableFor((ColumnViewer)this.fPeripheralViewer, 2, this);
        int i = 0;
        while (i < fgColumnInfo.length) {
            TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.fPeripheralViewer, 16384);
            TreeColumn treeColumn = treeViewerColumn.getColumn();
            String headerName = PeripheralRendering.fgColumnInfo[i].header;
            treeColumn.setText(headerName);
            treeColumn.setResizable(true);
            treeColumn.setMoveable(true);
            treeColumnLayout.setColumnData((Widget)treeColumn, (ColumnLayoutData)new ColumnWeightData(PeripheralRendering.fgColumnInfo[i].weight, PeripheralRendering.fgColumnInfo[i].weight * 5, true));
            treeViewerColumn.setLabelProvider((CellLabelProvider)new PeripheralColumnLabelProvider(this.fPeripheralViewer, (IMemoryBlockExtension)this.fMemoryBlock, PeripheralRendering.fgColumnInfo[i].type));
            if (PeripheralRendering.fgColumnInfo[i].type == PeripheralColumnInfo.ColumnType.VALUE) {
                treeViewerColumn.setEditingSupport((EditingSupport)new PeripheralEditingSupport(this.fPeripheralViewer));
            }
            if (PeripheralRendering.fgColumnInfo[i].sortable) {
                treeColumn.addSelectionListener((SelectionListener)this.getSelectionAdapter(treeColumn, i));
            }
            ++i;
        }
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        this.fPeripheralViewer.setInput((Object)this.getMemoryBlock());
        this.performExpandAction(true);
        this.createPopupMenu(control);
        this.createActions();
        IMenuListener menuListener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                PeripheralRendering.this.fillContextMenu(manager);
            }
        };
        this.addPopupMenu(menuListener);
        this.addDebugEventListener();
        this.addToSyncService();
        this.trackTreeSelectionChanges();
        this.fRefreshJob.schedule();
        return composite;
    }

    private SelectionAdapter getSelectionAdapter(final TreeColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PeripheralRendering.this.fComparator.setColumn(index);
                int dir = PeripheralRendering.this.fComparator.getDirection();
                PeripheralRendering.this.fPeripheralViewer.getTree().setSortDirection(dir);
                PeripheralRendering.this.fPeripheralViewer.getTree().setSortColumn(column);
                PeripheralRendering.this.refresh();
            }
        };
        return selectionAdapter;
    }

    private void addPopupMenu(IMenuListener menuListener) {
        MenuManager menuManager = this.getPopupMenuManager();
        menuManager.addMenuListener(menuListener);
    }

    private void addToSyncService() {
        IMemoryRenderingSynchronizationService synchronizationService = this.getMemoryRenderingContainer().getMemoryRenderingSite().getSynchronizationService();
        if (synchronizationService != null) {
            synchronizationService.addPropertyChangeListener((IPropertyChangeListener)this, new String[]{"selectedAddress"});
        }
    }

    private void addDebugEventListener() {
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    private void removeDebugEventListener() {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }

    private void trackTreeSelectionChanges() {
        this.fPeripheralViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                if (selectionChangedEvent.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)selectionChangedEvent.getSelection();
                    PeripheralRegisterVMNode peripheralRegister = null;
                    Object object = selection.getFirstElement();
                    if (object instanceof PeripheralRegisterVMNode) {
                        peripheralRegister = (PeripheralRegisterVMNode)object;
                    }
                    PeripheralRendering.this.postChange(peripheralRegister);
                }
            }
        });
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            if (events[i].getKind() == 16 && events[i].getSource() == this.fMemoryBlock) {
                this.fRefreshJob.schedule();
            }
            ++i;
        }
    }

    public void activated() {
        if (this.fContainer.getMemoryRenderingSite().getSynchronizationService() != null) {
            this.fContainer.getMemoryRenderingSite().getSynchronizationService().setSynchronizationProvider((IMemoryRendering)this);
        }
    }

    public void deactivated() {
    }

    public void becomesHidden() {
    }

    public void becomesVisible() {
    }

    private void handleSelectedAddressChanged(BigInteger bigInteger) {
        Object selection = this.findSelection(bigInteger);
        if (selection != null) {
            StructuredSelection structuredSelection = new StructuredSelection(selection);
            this.fPeripheralViewer.setSelection((ISelection)structuredSelection);
            Object element = structuredSelection.getFirstElement();
            if (element != null) {
                this.fPeripheralViewer.reveal(element);
            }
        }
    }

    private void postChange(PeripheralRegisterVMNode peripheralRegister) {
        if (peripheralRegister != null) {
            try {
                if (peripheralRegister.isField()) {
                    peripheralRegister = (PeripheralRegisterVMNode)peripheralRegister.getParent();
                }
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)this, "selectedAddress", null, (Object)peripheralRegister.getBigAbsoluteAddress());
                this.firePropertyChangedEvent(propertyChangeEvent);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this) {
            return;
        }
        if (propertyChangeEvent.getProperty().equals("selectedAddress") && propertyChangeEvent.getNewValue() instanceof BigInteger) {
            this.handleSelectedAddressChanged((BigInteger)propertyChangeEvent.getNewValue());
        }
    }

    public void refresh() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("PeripheralRendering.refresh()");
        }
        this.fPeripheralViewer.refresh();
        if (this.fMemoryBlock != null) {
            PeripheralGroupVMNode node = this.fMemoryBlock.getPeripheralRegisterGroup();
            node.decrementFadingLevel();
            if (Activator.getInstance().isDebugging()) {
                System.out.println("PeripheralRendering.refresh() decrementRecentChanges");
            }
        }
    }

    protected void createActions() {
        this.fCollapseRegistersAction = new Action(){

            public void run() {
                PeripheralRendering.this.performExpandAction(true);
            }
        };
        this.fCollapseRegistersAction.setText("Collapse registers");
        this.fCollapseRegistersAction.setToolTipText("Collapse registers");
        this.fCollapseRegistersAction.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"org.eclipse.embedcdt.debug.gdbjtag.ui", (String)"icons/register_obj.png"));
        this.fShowFieldsAction = new Action(){

            public void run() {
                PeripheralRendering.this.performExpandAction(false);
            }
        };
        this.fShowFieldsAction.setText("Show fields");
        this.fShowFieldsAction.setToolTipText("Show fields");
        this.fShowFieldsAction.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"org.eclipse.embedcdt.debug.gdbjtag.ui", (String)"icons/field.png"));
        this.fRefreshMenuAction = new Action(){

            public void run() {
                PeripheralRendering.this.refresh();
            }
        };
        this.fRefreshMenuAction.setText("Refresh");
        this.fRefreshMenuAction.setToolTipText("Refresh view");
        this.fRefreshMenuAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_REDO"));
        this.fAddFilterAction = new Action(){

            public void run() {
                PeripheralRendering.this.performAddFilterAction();
            }
        };
        this.fAddFilterAction.setText("Add filter...");
        this.fAddFilterAction.setImageDescriptor(Activator.getInstance().getImageDescriptor("filter"));
        this.fRemoveFilterAction = new Action(){

            public void run() {
                PeripheralRendering.this.performRemoveFilterAction();
            }
        };
        this.fRemoveFilterAction.setText("Remove filter...");
        this.fRemoveFilterAction.setImageDescriptor(Activator.getInstance().getImageDescriptor("filter_rem"));
        this.fForceReadAction = new Action(){

            public void run() {
                PeripheralRendering.this.performForceReadAction();
            }
        };
        this.fForceReadAction.setText("Force read of register with side effects");
        this.fForceReadAction.setImageDescriptor(Activator.getInstance().getImageDescriptor("force_read"));
    }

    private void performExpandAction(boolean collapseRegisters) {
        if (this.fPeripheralViewer != null && !this.fPeripheralViewer.getControl().isDisposed()) {
            this.expandRecursive(this.fPeripheralViewer.getTree().getItems(), !collapseRegisters);
        }
    }

    private void expandRecursive(TreeItem[] items, boolean expandRegisters) {
        if (items == null) {
            return;
        }
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            boolean isExpanded = true;
            Object node = treeItem.getData();
            if (node instanceof PeripheralRegisterArrayVMNode) {
                isExpanded = false;
            } else if (node instanceof PeripheralClusterArrayVMNode) {
                isExpanded = false;
            } else if (node instanceof PeripheralGroupVMNode) {
                isExpanded = true;
            } else if (node instanceof PeripheralRegisterVMNode) {
                isExpanded = ((PeripheralRegisterVMNode)node).isRegister() ? expandRegisters : false;
            }
            treeItem.setExpanded(isExpanded);
            this.expandRecursive(treeItem.getItems(), expandRegisters);
            ++n2;
        }
    }

    private void performAddFilterAction() {
        String currentFilter = "";
        ViewerFilter[] filters = this.fPeripheralViewer.getFilters();
        if (filters.length > 0 && filters[0] instanceof PeripheralNameFilter) {
            currentFilter = ((PeripheralNameFilter)filters[0]).getFilterText();
        }
        this.performRemoveFilterAction();
        PeripheralFilterDialog dialog = new PeripheralFilterDialog(this.getControl().getShell(), currentFilter);
        if (dialog.open() != 0) {
            return;
        }
        String filter = dialog.getValue();
        if (filter == null || filter.isEmpty()) {
            return;
        }
        PeripheralNameFilter peripheralNameFilter = new PeripheralNameFilter(filter);
        this.fPeripheralViewer.addFilter((ViewerFilter)peripheralNameFilter);
    }

    private void performRemoveFilterAction() {
        ViewerFilter[] filters = this.fPeripheralViewer.getFilters();
        int i = 0;
        while (i < filters.length) {
            this.fPeripheralViewer.removeFilter(filters[i]);
            filters[i] = null;
            ++i;
        }
    }

    private void performForceReadAction() {
        Object object = this.getSelection();
        if (object instanceof PeripheralRegisterVMNode) {
            PeripheralRegisterVMNode peripheralRegister = (PeripheralRegisterVMNode)object;
            peripheralRegister.forceReadRegister();
        }
    }

    protected void fillContextMenu(IMenuManager menuManager) {
        PeripheralRegisterVMNode peripheralRegister;
        PluginActionContributionItem itemToRemove = null;
        IContributionItem[] items = menuManager.getItems();
        int i = 0;
        while (i < items.length) {
            PluginActionContributionItem item;
            if (items[i] instanceof PluginActionContributionItem && "org.eclipse.cdt.debug.internal.ui.actions.AddWatchpointOnMemoryActionDelegate.1".equals((item = (PluginActionContributionItem)items[i]).getAction().getId())) {
                itemToRemove = item;
                break;
            }
            ++i;
        }
        if (itemToRemove != null) {
            menuManager.remove(itemToRemove);
        }
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.fRefreshMenuAction);
        menuManager.add((IAction)this.fAddFilterAction);
        menuManager.add((IAction)this.fRemoveFilterAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.fCollapseRegistersAction);
        menuManager.add((IAction)this.fShowFieldsAction);
        boolean hasForceRead = false;
        Object object = this.getSelection();
        if (object instanceof PeripheralRegisterVMNode && !(peripheralRegister = (PeripheralRegisterVMNode)object).isField()) {
            hasForceRead = peripheralRegister.hasReadAction();
        }
        if (hasForceRead) {
            menuManager.add((IContributionItem)new Separator());
            menuManager.add((IAction)this.fForceReadAction);
        }
    }

    public String getString(String renderingTypeId, BigInteger address, MemoryByte[] data) {
        return null;
    }

    public byte[] getBytes(String renderingTypeId, BigInteger address, MemoryByte[] currentValues, String newValue) {
        return null;
    }

    @Override
    public void linkSelected(String link) {
    }

    private Object findSelection(BigInteger bigInteger) {
        return null;
    }

    public Control getControl() {
        return this.fPeripheralViewer.getControl();
    }

    public Image getImage() {
        return Activator.getInstance().getImage("peripheral");
    }

    public String getLabel() {
        String string = null;
        if (this.fMemoryBlock != null) {
            String string2 = new String();
            try {
                string2 = this.fMemoryBlock.getBigBaseAddress().toString(16).toUpperCase();
            }
            catch (DebugException debugException) {
                // empty catch block
            }
            string = String.format("%s: 0x%s", this.fMemoryBlock.getPeripheralInstance().getDisplayName(), string2);
        }
        return string == null ? this.getClass().getSimpleName() : string;
    }

    public IMemoryBlock getMemoryBlock() {
        return this.fMemoryBlock;
    }

    public String getRenderingId() {
        return this.fRenderingId;
    }

    private Object getSelection() {
        TreeSelection treeSelection;
        Object object = null;
        ISelection selection = this.fPeripheralViewer.getSelection();
        if (selection instanceof TreeSelection && (treeSelection = (TreeSelection)selection).size() == 1) {
            object = treeSelection.getFirstElement();
        }
        return object;
    }
}

