/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.swt.custom;

import com.espressif.idf.core.logging.Logger;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TextWithButton {
    private Text text;
    private Label button;
    private Composite baseComposite;
    private String textWithDynamicVariables;

    public TextWithButton(Composite parent, int style) {
        this.baseComposite = new Composite(parent, style);
        this.baseComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout baseCompositeGridLayout = new GridLayout(2, false);
        baseCompositeGridLayout.marginHeight = 0;
        baseCompositeGridLayout.marginWidth = 0;
        this.baseComposite.setLayout((Layout)baseCompositeGridLayout);
        this.baseComposite.setBackground(new Color((Device)parent.getDisplay(), new RGB(255, 255, 255)));
        this.baseComposite.setBackgroundMode(2);
        this.text = new Text(this.baseComposite, 4);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true));
        final Image buttonShowImage = ImageDescriptor.createFromURL((URL)this.getClass().getResource("/icons/show.png")).createImage();
        final Image buttonHideImage = ImageDescriptor.createFromURL((URL)this.getClass().getResource("/icons/hide.png")).createImage();
        this.button = new Label(this.baseComposite, 0);
        this.button.setLayoutData((Object)new GridData(4, 4, false, true));
        this.button.setImage(buttonShowImage);
        this.button.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (!TextWithButton.this.text.getEditable()) {
                    this.showDynamicVariables();
                    return;
                }
                TextWithButton.this.button.setImage(buttonHideImage);
                TextWithButton.this.textWithDynamicVariables = TextWithButton.this.text.getText();
                TextWithButton.this.text.setEditable(false);
                try {
                    TextWithButton.this.text.setText(VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(TextWithButton.this.textWithDynamicVariables, false));
                }
                catch (CoreException e1) {
                    Logger.log((Exception)((Object)e1));
                }
            }

            private void showDynamicVariables() {
                TextWithButton.this.text.setEditable(true);
                TextWithButton.this.button.setImage(buttonShowImage);
                TextWithButton.this.text.setText(TextWithButton.this.textWithDynamicVariables);
            }
        });
        this.button.addDisposeListener(e -> {
            buttonHideImage.dispose();
            buttonShowImage.dispose();
        });
    }

    public void insert(String variableExpression) {
        this.text.insert(variableExpression);
    }

    public void addMouseTrackListener(MouseTrackAdapter mouseTrackAdapter) {
        this.text.addMouseTrackListener((MouseTrackListener)mouseTrackAdapter);
    }

    public String getText() {
        return this.text.getEditable() ? this.text.getText() : this.textWithDynamicVariables;
    }

    public Control getControl() {
        return this.text;
    }

    public void setToolTipText(String trim) {
        this.text.setToolTipText(trim);
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.text.addModifyListener(modifyListener);
    }

    public void setLayoutData(GridData gd) {
        this.baseComposite.setLayoutData((Object)gd);
    }

    public void setText(String str) {
        this.text.setText(str);
    }

    public void setEnabled(boolean enabled) {
        this.text.setEnabled(enabled);
        this.button.setEnabled(enabled);
    }

    public void setParent(Group group) {
        this.baseComposite.setParent((Composite)group);
    }

    public void addTraverseListener(TraverseListener traverseListener) {
        this.baseComposite.addTraverseListener(traverseListener);
    }
}

