/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.swt.custom;

import com.espressif.idf.swt.messages.Messages;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.themes.CascadingColorRegistry;

public class StyledInfoText {
    private static final String IMAGE_CODE = "\ufffc";
    private StyledText styledText;
    private String text = String.format(Messages.styledTextInfoDefaultMsg, "\ufffc", Messages.styledTextRestoreDefaultsLinkMsg);
    private StyleRange linkStyleRange;

    public StyledInfoText(Composite parent) {
        this.styledText = new StyledText(parent, 74);
        GridData gd = new GridData(768);
        gd.widthHint = 100;
        this.styledText.setLayoutData((Object)gd);
        CascadingColorRegistry colorRegistry = new CascadingColorRegistry(PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry());
        Color colorInfo = colorRegistry.get("org.eclipse.ui.workbench.INFORMATION_BACKGROUND");
        this.styledText.setBackground(colorInfo);
        this.styledText.setText(this.text);
        this.linkStyleRange = new StyleRange(this.text.indexOf(Messages.styledTextRestoreDefaultsLinkMsg), Messages.styledTextRestoreDefaultsLinkMsg.length(), null, null);
        this.linkStyleRange.underline = true;
        this.linkStyleRange.underlineStyle = 4;
        this.styledText.setStyleRange(this.linkStyleRange);
        this.addAllListeners();
    }

    public void setMouseListenerAction(final Runnable action) {
        this.styledText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                int offset = StyledInfoText.this.styledText.getOffsetAtPoint(new Point(e.x, e.y));
                if (offset >= StyledInfoText.this.linkStyleRange.start && offset < StyledInfoText.this.linkStyleRange.start + StyledInfoText.this.linkStyleRange.length) {
                    action.run();
                }
            }
        });
    }

    public int getOffsetAtPoint(Point point) {
        return this.styledText.getOffsetAtPoint(point);
    }

    private void addAllListeners() {
        Image buttonShowImage = ImageDescriptor.createFromURL((URL)this.getClass().getResource("/icons/show.png")).createImage();
        Image infoButtonImage = ImageDescriptor.createFromImage((Image)JFaceResources.getImage((String)"dialog_messasge_info_image")).createImage();
        Image[] images = new Image[]{infoButtonImage, buttonShowImage, buttonShowImage};
        int[] offsets = new int[images.length];
        int lastOffset = 0;
        int i = 0;
        while (i < images.length) {
            int offset;
            offsets[i] = offset = this.text.indexOf(IMAGE_CODE, lastOffset);
            this.addImage(images[i], offset, this.styledText);
            lastOffset = offset + 1;
            ++i;
        }
        this.addVerifyListener(images, offsets);
        this.addPaintObjectListener(images, offsets);
        this.addDisposeListener(images);
    }

    private void addDisposeListener(Image[] images) {
        this.styledText.addDisposeListener(e -> {
            Image[] imageArray2 = images;
            int n = images.length;
            int n2 = 0;
            while (n2 < n) {
                Image image = imageArray2[n2];
                image.dispose();
                ++n2;
            }
        });
    }

    private void addVerifyListener(Image[] images, int[] offsets) {
        this.styledText.addVerifyListener(e -> {
            int start = e.start;
            int replaceCharCount = e.end - e.start;
            int newCharCount = e.text.length();
            int i = 0;
            while (i < offsets.length) {
                int offset = offsets[i];
                if (start <= offset && offset < start + replaceCharCount) {
                    if (images[i] != null && !images[i].isDisposed()) {
                        images[i].dispose();
                        imageArray[i] = null;
                    }
                    offset = -1;
                }
                if (offset != -1 && offset >= start) {
                    offset += newCharCount - replaceCharCount;
                }
                nArray[i] = offset;
                ++i;
            }
        });
    }

    private void addPaintObjectListener(Image[] images, int[] offsets) {
        this.styledText.addPaintObjectListener(event -> {
            GC gc = event.gc;
            StyleRange style = event.style;
            int start = style.start;
            int i = 0;
            while (i < offsets.length) {
                int offset = offsets[i];
                if (start == offset) {
                    Image image = images[i];
                    int x = event.x;
                    int y = event.y + event.ascent - style.metrics.ascent + 3;
                    gc.drawImage(image, x, y);
                }
                ++i;
            }
        });
    }

    private void addImage(Image image, int offset, StyledText styledText) {
        StyleRange style = new StyleRange();
        style.start = offset;
        style.length = 1;
        Rectangle rect = image.getBounds();
        style.metrics = new GlyphMetrics(rect.height, 0, rect.width);
        styledText.setStyleRange(style);
    }
}

