/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.sdk.config.ui;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.SDKConfigUtil;
import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.sdk.config.core.KConfigMenuItem;
import com.espressif.idf.sdk.config.core.KConfigMenuProcessor;
import com.espressif.idf.sdk.config.core.server.CommandType;
import com.espressif.idf.sdk.config.core.server.ConfigServerManager;
import com.espressif.idf.sdk.config.core.server.IJsonConfigOutput;
import com.espressif.idf.sdk.config.core.server.IMessageHandlerListener;
import com.espressif.idf.sdk.config.core.server.JsonConfigProcessor;
import com.espressif.idf.sdk.config.core.server.JsonConfigServer;
import com.espressif.idf.sdk.config.ui.ConfigContentProvider;
import com.espressif.idf.sdk.config.ui.ConfigLabelProvider;
import com.espressif.idf.sdk.config.ui.Messages;
import com.espressif.idf.sdk.config.ui.SDKConfigUIPlugin;
import com.espressif.idf.sdk.config.ui.SDKConfigurationFilter;
import com.espressif.idf.ui.IDFConsole;
import com.espressif.idf.ui.dialogs.HelpPopupDialog;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.progress.IProgressService;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;

public class SDKConfigurationEditor
extends MultiPageEditorPart
implements ISaveablePart,
IMessageHandlerListener,
IPageChangedListener {
    public static String EDITOR_ID = "com.espressif.idf.sdk.config.ui.editor";
    private static final String ICONS_INFO_OBJ_GIF = "icons/help.gif";
    private static final String ICONS_SDK_TOOL_CONFIG_PNG = "icons/sdk_tool_config.png";
    private TreeViewer treeViewer;
    private Group updateUIComposite;
    private IProject project;
    private boolean isDirty;
    private JsonConfigServer configServer;
    private JSONObject valuesJsonMap;
    private JSONObject visibleJsonMap;
    private JSONObject rangesJsonMap;
    private String serverMessage;
    private KConfigMenuItem selectedElement;
    private JSONObject modifiedJsonMap = new JSONObject();
    private HelpPopupDialog infoDialog;
    private CommandType type;
    private ScrolledComposite sc;

    public SDKConfigurationEditor() {
        this.addPageChangedListener(this);
    }

    protected void createPages() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IProgressService progressService = workbench.getProgressService();
        String buildFolder = this.getCurrentBuildFolder();
        IRunnableWithProgress runnable = monitor -> {
            monitor.beginTask(Messages.SDKConfigurationEditor_LaunchSDKConfigEditor, 3);
            try {
                String configMenuJsonPath;
                if (this.isSdkConfigLocatedInBuildFolder()) {
                    IDFUtil.setBuildDir((IProject)this.project, (String)this.getSdkConfigParentFolderOpt().get().getLocation().toOSString());
                }
                if ((configMenuJsonPath = new SDKConfigUtil().getConfigMenuFilePath(this.project)) == null || !new File(configMenuJsonPath).exists()) {
                    Display.getDefault().asyncExec(() -> {
                        String errorMsg = Messages.SDKConfigurationEditor_UnableFindKConfigFile + configMenuJsonPath;
                        this.createErrorPage(errorMsg);
                    });
                    return;
                }
                monitor.worked(1);
                monitor.setTaskName(Messages.SDKConfigurationEditor_StartingJSONConfigServer);
                this.initConfigServer(this.project);
                monitor.worked(2);
            }
            catch (Exception x) {
                this.rollbackBuildFolder(buildFolder);
                throw new InvocationTargetException(x, x.getMessage());
            }
        };
        try {
            progressService.busyCursorWhile(runnable);
        }
        catch (Exception e) {
            Logger.log((Plugin)SDKConfigUIPlugin.getDefault(), (Exception)e);
        }
        if (this.valuesJsonMap == null) {
            String errorMsg = Messages.SDKConfigurationEditor_ErrorRetrievingOutput;
            this.createErrorPage(errorMsg);
            return;
        }
        this.setPartName(this.getPartName() + " (" + this.getFile().getName() + ")");
        this.createDesignPage();
        this.createSourcePage();
        this.rollbackBuildFolder(buildFolder);
    }

    private void createSourcePage() {
        try {
            TextEditor editor = new TextEditor();
            Object control = editor.getAdapter(Control.class);
            if (control instanceof StyledText) {
                ((StyledText)control).setEditable(false);
            }
            int index = this.addPage((IEditorPart)editor, this.getEditorInput());
            this.setPageText(index, Messages.SDKConfigurationEditor_Preview);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)Messages.SDKConfigurationEditor_Error, null, (IStatus)e.getStatus());
        }
    }

    private void createDesignPage() {
        List children;
        Composite parent = new Composite(this.getContainer(), 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        GridData layoutData = new GridData();
        layoutData.grabExcessVerticalSpace = true;
        layoutData.verticalAlignment = 4;
        Group treeComposite = new Group(parent, 640);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 2;
        treeComposite.setLayout((Layout)layout);
        treeComposite.setLayoutData((Object)layoutData);
        FilteredTree transfersTree = this.createFilteredTree(treeComposite);
        transfersTree.setLayoutData((Object)new GridData(1808));
        this.treeViewer = transfersTree.getViewer();
        this.treeViewer.setContentProvider((IContentProvider)new ConfigContentProvider(this.project, this.getFile()));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ConfigLabelProvider());
        this.treeViewer.setUseHashlookup(true);
        layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.verticalAlignment = 4;
        this.treeViewer.getControl().setLayoutData((Object)layoutData);
        this.hookListeners();
        KConfigMenuItem initalInput = this.getInitalInput();
        this.treeViewer.setInput((Object)initalInput);
        this.treeViewer.expandToLevel((Object)this.getComponentConfigElement(initalInput), 1);
        this.sc = new ScrolledComposite(parent, 768);
        this.sc.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 500;
        this.sc.setLayoutData((Object)gridData);
        this.updateUIComposite = new Group((Composite)this.sc, 512);
        this.updateUIComposite.setLayout((Layout)new GridLayout(1, false));
        gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 500;
        this.updateUIComposite.setLayoutData((Object)gridData);
        if (initalInput != null && !(children = initalInput.getChildren()).isEmpty()) {
            KConfigMenuItem kConfigMenuItem = (KConfigMenuItem)children.get(0);
            this.updateUI(kConfigMenuItem);
        }
        int index = this.addPage((Control)parent);
        this.setPageText(index, Messages.SDKConfigurationEditor_Design);
    }

    private KConfigMenuItem getComponentConfigElement(KConfigMenuItem initalInput) {
        if (initalInput == null) {
            return null;
        }
        List children = initalInput.getChildren();
        for (KConfigMenuItem kConfigMenuItem : children) {
            if (!kConfigMenuItem.getTitle().equals("Component config")) continue;
            return kConfigMenuItem;
        }
        return null;
    }

    private void createErrorPage(String errorMessage) {
        Composite parent = new Composite(this.getContainer(), 512);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        parent.setLayout((Layout)layout);
        new Label(parent, 0).setText(errorMessage);
        int index = this.addPage((Control)parent);
        this.setPageText(index, Messages.SDKConfigurationEditor_Design);
    }

    private IFile getFile() {
        return ((FileEditorInput)this.getEditorInput()).getFile();
    }

    protected IProject getProject() {
        IFileEditorInput editorInput = (IFileEditorInput)this.getEditorInput();
        IFile file = editorInput.getFile();
        return file.getProject();
    }

    protected void initConfigServer(IProject project) throws IOException, ParseException {
        MessageConsoleStream console = new IDFConsole().getConsoleStream("JSON Configuration Server Console", null, false);
        this.configServer = ConfigServerManager.INSTANCE.getServer(project, this.getFile());
        this.configServer.addListener((IMessageHandlerListener)this);
        this.configServer.addConsole(console);
        JsonConfigProcessor jsonProcessor = new JsonConfigProcessor();
        int MAX_NO_OF_ATTEMPTS = 120;
        String sdkconfigTimeout = this.getSystemProperty("sdkconfig.timeout");
        if (!StringUtil.isEmpty((String)sdkconfigTimeout)) {
            MAX_NO_OF_ATTEMPTS = Integer.valueOf(sdkconfigTimeout);
        }
        if (this.isReady(MAX_NO_OF_ATTEMPTS, 1000L, jsonProcessor)) {
            String response = jsonProcessor.getInitialOutput(this.serverMessage);
            IJsonConfigOutput output = this.configServer.getOutput(response, false);
            this.valuesJsonMap = output.getValuesJsonMap();
            this.visibleJsonMap = output.getVisibleJsonMap();
            this.rangesJsonMap = output.getRangesJsonMap();
        }
    }

    protected void update() throws ParseException {
        JsonConfigProcessor jsonProcessor = new JsonConfigProcessor();
        String response = jsonProcessor.getInitialOutput(this.serverMessage);
        if (response == null) {
            return;
        }
        IJsonConfigOutput output = this.configServer.getOutput(response, true);
        this.valuesJsonMap = output.getValuesJsonMap();
        this.visibleJsonMap = output.getVisibleJsonMap();
        this.rangesJsonMap = output.getRangesJsonMap();
    }

    private boolean isReady(int maxAttempts, long sleepInterval, JsonConfigProcessor jsonProcessor) throws IOException {
        int waitCount = 0;
        while (this.serverMessage == null || jsonProcessor.getInitialOutput(this.serverMessage) == null) {
            if (this.type == CommandType.CONNECTION_CLOSED || waitCount >= maxAttempts) {
                return false;
            }
            try {
                Thread.sleep(sleepInterval);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++waitCount;
        }
        return true;
    }

    public void dispose() {
        if (this.configServer != null) {
            this.configServer.destroy();
        }
        ConfigServerManager.INSTANCE.deleteServer(this.project, this.getFile());
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"version", (Object)2);
        jsonObject.put((Object)"set", (Object)this.modifiedJsonMap);
        jsonObject.put((Object)"save", null);
        String command = jsonObject.toJSONString();
        this.configServer.execute(command, CommandType.SAVE);
        this.modifiedJsonMap.clear();
        this.isDirty = false;
        this.editorDirtyStateChanged();
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException(Messages.SDKConfigurationEditor_InvalidInput);
        }
        super.init(site, editorInput);
        this.project = this.getProject();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public KConfigMenuItem getInitalInput() {
        KConfigMenuProcessor jsonReader = new KConfigMenuProcessor(this.project);
        try {
            return jsonReader.reader();
        }
        catch (Exception e) {
            Logger.log((Plugin)SDKConfigUIPlugin.getDefault(), (Exception)e);
            return null;
        }
    }

    protected void hookListeners() {
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    KConfigMenuItem selectedElement = (KConfigMenuItem)event.getStructuredSelection().getFirstElement();
                    SDKConfigurationEditor.this.updateUI(selectedElement);
                }
            }
        });
    }

    private FilteredTree createFilteredTree(Group group) {
        SDKConfigurationFilter patternFilter = new SDKConfigurationFilter();
        int style = 2820;
        FilteredTree transfersTree = new FilteredTree((Composite)group, style, patternFilter, true){

            protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
                return new TreeViewer(parent, style);
            }
        };
        return transfersTree;
    }

    private void updateUI(KConfigMenuItem selectedElement) {
        Control[] updateUICompositeControls;
        if (selectedElement == null || this.updateUIComposite == null || this.updateUIComposite.isDisposed() || this.valuesJsonMap == null) {
            return;
        }
        this.selectedElement = selectedElement;
        Control[] controlArray = updateUICompositeControls = this.updateUIComposite.getChildren();
        int n = updateUICompositeControls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        this.updateUIComposite.setLayout((Layout)new GridLayout(3, false));
        this.updateUIComposite.setText(selectedElement.getTitle());
        GridData updateCompsiteGD = new GridData(4, 4, true, true);
        updateCompsiteGD.verticalIndent = 10;
        this.updateUIComposite.setLayoutData((Object)updateCompsiteGD);
        this.renderMenuItems(selectedElement);
        this.sc.setContent((Control)this.updateUIComposite);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        this.sc.setMinSize(this.updateUIComposite.computeSize(-1, -1));
        this.sc.setShowFocusedControl(true);
        this.updateUIComposite.layout(true);
    }

    protected void renderMenuItems(KConfigMenuItem selectedElement) {
        List children = selectedElement.getChildren();
        for (final KConfigMenuItem kConfigMenuItem : children) {
            String type = kConfigMenuItem.getType();
            String configKey = kConfigMenuItem.getId();
            Object configValue = this.valuesJsonMap.get((Object)configKey);
            boolean isVisible = this.visibleJsonMap.get((Object)configKey) != null ? (Boolean)this.visibleJsonMap.get((Object)configKey) : false;
            Object newConfigValue = this.modifiedJsonMap.get((Object)configKey);
            String helpInfo = kConfigMenuItem.getHelp();
            if (isVisible && type.equals("string")) {
                labelName = new Label((Composite)this.updateUIComposite, 0);
                labelName.setText(kConfigMenuItem.getTitle());
                textControl = new Text((Composite)this.updateUIComposite, 2052);
                gridData = new GridData();
                gridData.widthHint = 250;
                textControl.setLayoutData((Object)gridData);
                textControl.setToolTipText(helpInfo);
                if (configValue != null) {
                    textControl.setText(newConfigValue != null ? (String)newConfigValue : (String)configValue);
                }
                textControl.addModifyListener(this.addModifyListener(configKey, textControl));
                this.addTooltipImage(kConfigMenuItem);
            } else if (isVisible && type.equals("hex")) {
                labelName = new Label((Composite)this.updateUIComposite, 0);
                labelName.setText(kConfigMenuItem.getTitle().concat(" (hex)"));
                textControl = new Text((Composite)this.updateUIComposite, 2052);
                gridData = new GridData();
                gridData.widthHint = 250;
                textControl.setLayoutData((Object)gridData);
                textControl.setToolTipText(helpInfo);
                if (configValue != null) {
                    String hexText = newConfigValue != null ? Long.toHexString((Long)newConfigValue) : Long.toHexString((Long)configValue);
                    textControl.setText("0x" + hexText.toUpperCase());
                }
                textControl.addModifyListener(this.addModifyListener(configKey, textControl));
                this.addTooltipImage(kConfigMenuItem);
            } else if (kConfigMenuItem.isMenuConfig()) {
                Button button = this.createCheckBox(kConfigMenuItem, configKey, configValue, helpInfo);
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        SDKConfigurationEditor.this.renderMenuItems(kConfigMenuItem);
                    }
                });
                if (kConfigMenuItem.hasChildren()) {
                    button.setImage(SDKConfigUIPlugin.getImage(ICONS_SDK_TOOL_CONFIG_PNG));
                }
                if (button.getSelection()) {
                    this.renderMenuItems(kConfigMenuItem);
                }
            } else if (isVisible && type.equals("bool")) {
                this.createCheckBox(kConfigMenuItem, configKey, configValue, helpInfo);
            } else if (isVisible && type.equals("int")) {
                labelName = new Label((Composite)this.updateUIComposite, 0);
                labelName.setText(kConfigMenuItem.getTitle());
                Text text = new Text((Composite)this.updateUIComposite, 2052);
                gridData = new GridData();
                gridData.widthHint = 250;
                text.setLayoutData((Object)gridData);
                text.setToolTipText(helpInfo);
                if (configValue != null) {
                    text.setText(newConfigValue != null ? String.valueOf(newConfigValue) : String.valueOf(configValue));
                }
                text.addModifyListener(this.addModifyListener(configKey, text));
                this.addTooltipImage(kConfigMenuItem);
            } else if (isVisible && type.equals("menu")) {
                this.renderMenuItems(kConfigMenuItem);
            } else if (type.equals("choice")) {
                Logger.logTrace((Plugin)SDKConfigUIPlugin.getDefault(), (String)("Config key >" + configKey + " visiblity status >" + isVisible));
                if (this.isExist(this.visibleJsonMap, configKey)) {
                    List choiceItems = kConfigMenuItem.getChildren();
                    Label labelName = new Label((Composite)this.updateUIComposite, 0);
                    labelName.setText(kConfigMenuItem.getTitle());
                    final Combo choiceCombo = new Combo((Composite)this.updateUIComposite, 12);
                    choiceCombo.setLayoutData((Object)new GridData(0, 0, false, false, 1, 1));
                    GridData gridData = new GridData();
                    gridData.widthHint = 250;
                    choiceCombo.setLayoutData((Object)gridData);
                    int index = 0;
                    for (KConfigMenuItem item : choiceItems) {
                        String localConfigKey = item.getId();
                        if (!this.isExist(this.visibleJsonMap, localConfigKey)) continue;
                        choiceCombo.add(item.getTitle());
                        choiceCombo.setData(item.getTitle(), (Object)localConfigKey);
                        if (this.isExist(this.valuesJsonMap, localConfigKey)) {
                            choiceCombo.select(index);
                        }
                        ++index;
                    }
                    choiceCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            Object key = choiceCombo.getData(choiceCombo.getText());
                            if (key != null) {
                                JSONObject jsonObj = new JSONObject();
                                jsonObj.put(key, (Object)true);
                                SDKConfigurationEditor.this.executeCommand(jsonObj);
                            }
                        }
                    });
                    this.addTooltipImage(kConfigMenuItem);
                }
            }
            if (type.equals("choice") || type.equals("menu") || !kConfigMenuItem.hasChildren()) continue;
            this.renderMenuItems(kConfigMenuItem);
        }
    }

    private Button createCheckBox(KConfigMenuItem kConfigMenuItem, final String configKey, Object configValue, String helpInfo) {
        final Button button = new Button((Composite)this.updateUIComposite, 32);
        button.setText(kConfigMenuItem.getTitle());
        button.setLayoutData((Object)new GridData(0, 0, false, false, 2, 1));
        button.setToolTipText(helpInfo);
        if (configValue != null) {
            button.setSelection(((Boolean)configValue).booleanValue());
        }
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSONObject jsonObj = new JSONObject();
                jsonObj.put((Object)configKey, (Object)button.getSelection());
                SDKConfigurationEditor.this.executeCommand(jsonObj);
            }
        });
        this.addTooltipImage(kConfigMenuItem);
        return button;
    }

    protected boolean isExist(JSONObject jsonMap, String key) {
        return jsonMap.get((Object)key) != null ? (Boolean)jsonMap.get((Object)key) : false;
    }

    protected void addTooltipImage(KConfigMenuItem kConfigMenuItem) {
        Label labelName = new Label((Composite)this.updateUIComposite, 0);
        labelName.setImage(SDKConfigUIPlugin.getImage(ICONS_INFO_OBJ_GIF));
        labelName.addListener(4, this.getMouseClickListener(kConfigMenuItem));
        labelName.setToolTipText(Messages.SDKConfigurationEditor_Help);
    }

    private Listener getMouseClickListener(final KConfigMenuItem kConfigMenuItem) {
        return new Listener(){

            public void handleEvent(Event event) {
                String help = kConfigMenuItem.getHelp();
                String title = kConfigMenuItem.getTitle();
                String configKey = kConfigMenuItem.getId();
                StringBuilder message = new StringBuilder();
                message.append(title);
                message.append("\n\n");
                message.append(help);
                Object range = SDKConfigurationEditor.this.rangesJsonMap.get((Object)configKey);
                if (range != null) {
                    message.append("\n\n");
                    message.append("Range Information:");
                    message.append("\n");
                    message.append(range.toString());
                }
                if (StringUtil.isEmpty((String)help)) {
                    String msg = MessageFormat.format(Messages.SDKConfigurationEditor_NoHelpAvailable, configKey);
                    Logger.log((Plugin)SDKConfigUIPlugin.getDefault(), (String)msg);
                    return;
                }
                Shell activeShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                if (SDKConfigurationEditor.this.infoDialog != null) {
                    SDKConfigurationEditor.this.infoDialog.close();
                }
                SDKConfigurationEditor.this.infoDialog = new HelpPopupDialog(activeShell, Messages.SDKConfigurationEditor_Help + " > " + configKey, message.toString());
                SDKConfigurationEditor.this.infoDialog.open();
            }
        };
    }

    protected ModifyListener addModifyListener(final String configKey, final Text textControl) {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = textControl.getText().toLowerCase();
                boolean isHex = text.startsWith("0x");
                SDKConfigurationEditor.this.isDirty = true;
                SDKConfigurationEditor.this.editorDirtyStateChanged();
                SDKConfigurationEditor.this.modifiedJsonMap.put((Object)configKey, isHex ? Long.valueOf(Long.parseLong(text.substring(2), 16)) : textControl.getText().trim());
            }
        };
    }

    protected void executeCommand(JSONObject jsonObj) {
        this.isDirty = true;
        this.editorDirtyStateChanged();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"version", (Object)2);
        jsonObject.put((Object)"set", (Object)jsonObj);
        String command = jsonObject.toJSONString();
        this.configServer.execute(command, CommandType.SET);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void editorDirtyStateChanged() {
        this.firePropertyChange(257);
    }

    public void notifyRequestServed(String message, CommandType type) {
        this.serverMessage = message;
        this.type = type;
        Logger.log((Plugin)SDKConfigUIPlugin.getDefault(), (String)message);
        if (this.selectedElement != null) {
            try {
                if (type == CommandType.LOAD) {
                    this.modifiedJsonMap.clear();
                    this.isDirty = false;
                    this.editorDirtyStateChanged();
                }
                this.update();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!SDKConfigurationEditor.this.treeViewer.getControl().isDisposed()) {
                            SDKConfigurationEditor.this.treeViewer.refresh();
                            SDKConfigurationEditor.this.updateUI(SDKConfigurationEditor.this.selectedElement);
                        }
                    }
                });
            }
            catch (ParseException e1) {
                Logger.log((Plugin)SDKConfigUIPlugin.getDefault(), (Exception)((Object)e1));
            }
        }
    }

    public void pageChanged(PageChangedEvent event) {
        IEditorPart activeEditor = this.getActiveEditor();
        if (activeEditor instanceof TextEditor) {
            String msg1 = Messages.SDKConfigurationEditor_SaveChanges;
            String msg2 = Messages.SDKConfigurationEditor_ChangesWontbeSaved;
            String title = Messages.SDKConfigurationEditor_SDKConfiguration;
            if (this.isDirty()) {
                boolean isOkay = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)title, (String)MessageFormat.format("{0} \n\n{1}", msg1, msg2));
                if (isOkay) {
                    this.doSave((IProgressMonitor)new NullProgressMonitor());
                }
                return;
            }
        }
    }

    public String getSystemProperty(String option) {
        if (option == null) {
            return null;
        }
        return System.getProperty(option);
    }

    private String getCurrentBuildFolder() {
        String buildFolder = "";
        try {
            buildFolder = IDFUtil.getBuildDir((IProject)this.project);
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        return buildFolder;
    }

    private void rollbackBuildFolder(String buildFolder) {
        try {
            IDFUtil.setBuildDir((IProject)this.project, (String)buildFolder);
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
    }

    private boolean isSdkConfigLocatedInBuildFolder() {
        Optional<IContainer> sdkConfigParentOpt = this.getSdkConfigParentFolderOpt();
        return sdkConfigParentOpt.isPresent() && sdkConfigParentOpt.get().exists(Path.fromPortableString((String)"config/kconfig_menus.json"));
    }

    private Optional<IContainer> getSdkConfigParentFolderOpt() {
        IEditorInput iEditorInput = this.getEditorInput();
        if (iEditorInput instanceof IFileEditorInput) {
            IFileEditorInput editorInput = (IFileEditorInput)iEditorInput;
            IFile sdkConfigFile = editorInput.getFile();
            return Optional.ofNullable(sdkConfigFile.getParent());
        }
        return Optional.empty();
    }
}

