/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.launch.serial.ui.internal;

import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.launch.serial.ui.internal.Activator;
import com.espressif.idf.launch.serial.ui.internal.Messages;
import com.espressif.idf.launch.serial.ui.internal.NewSerialFlashTargetWizardPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.ILaunchTargetManager;
import org.eclipse.launchbar.core.target.ILaunchTargetManager2;
import org.eclipse.launchbar.core.target.ILaunchTargetWorkingCopy;
import org.eclipse.launchbar.ui.target.LaunchTargetWizard;
import org.osgi.service.prefs.BackingStoreException;

public class NewSerialFlashTargetWizard
extends LaunchTargetWizard {
    private NewSerialFlashTargetWizardPage page;

    public NewSerialFlashTargetWizard() {
        this.setWindowTitle(Messages.NewSerialFlashTargetWizard_Title);
    }

    public void addPages() {
        super.addPages();
        this.page = new NewSerialFlashTargetWizardPage(this.getLaunchTarget());
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final ILaunchTargetManager targetManager = Activator.getService(ILaunchTargetManager.class);
        final String typeId = "com.espressif.idf.launch.serial.core.serialFlashTarget";
        final String id = this.page.getTargetName();
        ILaunchTarget target = ((ILaunchTargetManager2)targetManager).addLaunchTargetNoNotify(typeId, id);
        ILaunchTargetWorkingCopy wc = target.getWorkingCopy();
        wc.setId(id);
        wc.setAttribute("os", this.page.getOS());
        wc.setAttribute("arch", this.page.getArch());
        wc.setAttribute("com.espressif.idf.launch.serial.core.serialPort", this.page.getSerialPortName());
        wc.setAttribute("com.espressif.idf.launch.serial.core.idfTarget", this.page.getIDFTarget());
        wc.setAttribute("com.espressif.idf.launch.serial.core.board", this.page.getBoard());
        wc.setAttribute("com.espressif.idf.launch.serial.core.flash_voltage", this.page.getVoltage());
        this.setOpenOCDAdaptorLocation(wc);
        wc.save();
        this.storeLastUsedSerialPort();
        Job job = new Job(Messages.AddingTargetJobName){

            protected IStatus run(IProgressMonitor monitor) {
                targetManager.addLaunchTarget(typeId, id);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        return true;
    }

    private void setOpenOCDAdaptorLocation(ILaunchTargetWorkingCopy wc) {
        String usbLocation = this.page.getSelectedBoardUsbLocation();
        if (StringUtil.isEmpty((String)usbLocation)) {
            wc.setAttribute("OPENOCD_USB_ADAPTER_LOCATION", null);
        } else if (usbLocation.startsWith("usb://")) {
            usbLocation = usbLocation.substring("usb://".length());
            wc.setAttribute("OPENOCD_USB_ADAPTER_LOCATION", usbLocation);
        }
    }

    private void storeLastUsedSerialPort() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("com.espressif.idf.launch.serial.ui");
        preferences.put("com.espressif.idf.launch.serial.core.serialPort", this.page.getSerialPortName());
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public boolean canDelete() {
        return true;
    }

    public void performDelete() {
        ILaunchTargetManager targetMgr = Activator.getService(ILaunchTargetManager.class);
        ILaunchTarget target = this.getLaunchTarget();
        if (target != null) {
            targetMgr.removeLaunchTarget(target);
        }
    }
}

