/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.sdk.config.core.server;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.sdk.config.core.SDKConfigCorePlugin;
import com.espressif.idf.sdk.config.core.server.CommandType;
import com.espressif.idf.sdk.config.core.server.JsonConfigProcessor;
import com.espressif.idf.sdk.config.core.server.JsonConfigServer;
import com.espressif.idf.sdk.config.core.server.Messages;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class JsonConfigServerRunnable
implements Runnable {
    private JsonConfigServer configServer;
    private OutputStream in;
    private InputStream out;
    private CommandType type;
    private Process process;
    private IProject project;
    private String oldSdkconfigValue;

    public JsonConfigServerRunnable(Process process, JsonConfigServer configServer, IProject project, String oldSdkconfigValue) {
        this.process = process;
        this.configServer = configServer;
        this.project = project;
        this.oldSdkconfigValue = oldSdkconfigValue;
    }

    public void destory() {
        if (this.process != null) {
            this.stopProcess(this.process);
        }
    }

    private void stopProcess(Process process) {
        process.descendants().forEach(new Consumer<ProcessHandle>(){

            @Override
            public void accept(ProcessHandle t) {
                t.destroy();
            }
        });
        process.destroy();
    }

    public void executeCommand(String command, CommandType type) {
        this.type = type;
        String msg = MessageFormat.format(Messages.JsonConfigServerRunnable_CmdToBeExecuted, command);
        Logger.log((Plugin)SDKConfigCorePlugin.getPlugin(), (String)msg);
        PrintWriter pwdWriter = new PrintWriter(this.in);
        pwdWriter.println(command);
        pwdWriter.flush();
    }

    public boolean isAlive(Process p) {
        return p.isAlive();
    }

    @Override
    public void run() {
        StringBuilder builder = new StringBuilder();
        try {
            this.out = this.process.getInputStream();
            this.in = this.process.getOutputStream();
            byte[] buffer = new byte[4000];
            this.process.waitFor(3000L, TimeUnit.MILLISECONDS);
            boolean isAlive = true;
            while (isAlive) {
                int no = this.out.available();
                String output = builder.toString();
                if (no == 0 && !output.isEmpty() && this.isValidJson(output)) {
                    this.configServer.notifyHandler(output, this.type);
                    builder = new StringBuilder();
                } else if (no > 0) {
                    int n = this.out.read(buffer, 0, Math.min(no, buffer.length));
                    String string = new String(buffer, 0, n);
                    this.configServer.console.print(string);
                    this.configServer.console.flush();
                    builder.append(string);
                    if (string.contains("Server running")) {
                        try {
                            this.replaceOldCmakeCache();
                        }
                        catch (CoreException e) {
                            Logger.log((Exception)((Object)e));
                        }
                    }
                }
                this.process.waitFor(100L, TimeUnit.MILLISECONDS);
                isAlive = this.process.isAlive();
            }
            this.configServer.notifyHandler("Server connection closed", CommandType.CONNECTION_CLOSED);
        }
        catch (IOException e) {
            Logger.log((Exception)e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void replaceOldCmakeCache() throws CoreException {
        File cmakeCacheFile = new File(IDFUtil.getBuildDir((IProject)this.project).concat("/CMakeCache.txt"));
        if (cmakeCacheFile.exists() && !StringUtil.isEmpty((String)this.oldSdkconfigValue)) {
            Object var5_9;
            StringBuilder contentBuilder = new StringBuilder();
            String lineSeparator = System.lineSeparator();
            try {
                Throwable throwable = null;
                var5_9 = null;
                try (BufferedReader reader = new BufferedReader(new FileReader(cmakeCacheFile));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (line.startsWith("SDKCONFIG:UNINITIALIZED=")) {
                            contentBuilder.append(this.oldSdkconfigValue).append(lineSeparator);
                            continue;
                        }
                        contentBuilder.append(line).append(lineSeparator);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                Logger.log((Exception)e);
            }
            try {
                Throwable e = null;
                var5_9 = null;
                try (PrintWriter writer = new PrintWriter(new FileWriter(cmakeCacheFile));){
                    writer.print(contentBuilder.toString());
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                Logger.log((Exception)e);
            }
        }
    }

    protected boolean isValidJson(String output) {
        String jsonOutput = new JsonConfigProcessor().getInitialOutput(output);
        if (StringUtil.isEmpty((String)jsonOutput)) {
            return false;
        }
        try {
            JSONObject jsonObj = (JSONObject)new JSONParser().parse(jsonOutput);
            return jsonObj != null && jsonObj.get((Object)"visible") != null && jsonObj.get((Object)"values") != null && jsonObj.get((Object)"ranges") != null;
        }
        catch (ParseException e) {
            return false;
        }
    }
}

