/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.util;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.toolchain.ESPToolchain;
import java.util.NoSuchElementException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.build.ICBuildConfigurationManager;
import org.eclipse.cdt.core.build.ICBuildConfigurationManager2;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.Preferences;

public class RecheckConfigsHelper {
    private RecheckConfigsHelper() {
    }

    public static void revalidateToolchain(IProject project) {
        try {
            Preferences settings = InstanceScope.INSTANCE.getNode("org.eclipse.cdt.core").node("config").node(project.getName()).node(project.getActiveBuildConfig().getName());
            IToolChainManager toolChainManager = (IToolChainManager)CCorePlugin.getService(IToolChainManager.class);
            IToolChain anyEspToolChain = RecheckConfigsHelper.getESPToolChain(toolChainManager);
            String typeId = settings.get("cdt.toolChain.type", anyEspToolChain.getTypeId());
            String toolchainId = settings.get("cdt.toolChain.id", anyEspToolChain.getId());
            IToolChain currentToolChain = toolChainManager.getToolChain(typeId, toolchainId);
            if (!(currentToolChain instanceof ESPToolchain)) {
                currentToolChain = anyEspToolChain;
            }
            settings.put("cdt.toolChain.type", currentToolChain.getTypeId());
            settings.put("cdt.toolChain.id", currentToolChain.getId());
            RecheckConfigsHelper.recheckConfigs();
        }
        catch (NoSuchElementException | CoreException e) {
            Logger.log((Exception)e);
        }
    }

    private static void recheckConfigs() {
        ICBuildConfigurationManager mgr = (ICBuildConfigurationManager)CCorePlugin.getService(ICBuildConfigurationManager.class);
        ICBuildConfigurationManager2 manager = (ICBuildConfigurationManager2)mgr;
        manager.recheckConfigs();
    }

    private static IToolChain getESPToolChain(IToolChainManager toolChainManager) throws CoreException {
        return toolChainManager.getAllToolChains().stream().filter(ESPToolchain.class::isInstance).findFirst().orElseThrow();
    }
}

