/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.util;

import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.launchbar.core.ILaunchDescriptor;

public class LaunchUtil {
    private final ILaunchManager launchManager;

    public LaunchUtil(ILaunchManager launchManager) {
        this.launchManager = launchManager;
    }

    public ILaunchConfiguration findAppropriateLaunchConfig(ILaunchDescriptor descriptor, String configIndentifier) throws CoreException {
        IProject project = (IProject)descriptor.getAdapter(IProject.class);
        ILaunchConfiguration[] iLaunchConfigurationArray = this.launchManager.getLaunchConfigurations();
        int n = iLaunchConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration config = iLaunchConfigurationArray[n2];
            IResource[] mappedResource = config.getMappedResources();
            if (mappedResource != null && mappedResource.length > 0 && mappedResource[0].getProject().equals((Object)project) && config.getType().getIdentifier().contentEquals(configIndentifier)) {
                return config;
            }
            ++n2;
        }
        return null;
    }

    public ILaunchConfiguration getBoundConfiguration(ILaunchConfiguration configuration) throws CoreException {
        String bindedLaunchConfigName = configuration.getAttribute("com.espressif.idf.debug.gdbjtag.openocd.launchConfigurationName", "");
        ILaunchConfiguration[] launchConfigurations = this.launchManager.getLaunchConfigurations(DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("com.espressif.idf.launch.serial.launchConfigurationType"));
        ILaunchConfiguration defaultConfiguration = launchConfigurations[0];
        return Stream.of(launchConfigurations).filter(config -> config.getName().contentEquals(bindedLaunchConfigName)).findFirst().orElse(defaultConfiguration);
    }
}

