/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.util;

import com.espressif.idf.core.build.CsvBean;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.CsvTableDataService;
import com.opencsv.bean.CsvToBean;
import com.opencsv.bean.CsvToBeanBuilder;
import com.opencsv.bean.StatefulBeanToCsv;
import com.opencsv.bean.StatefulBeanToCsvBuilder;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.eclipse.core.resources.IFile;

public abstract class AbstractTableDataService<T extends CsvBean>
implements CsvTableDataService<T> {
    private Class<T> genericTypeClass;

    protected void initGenericTypeClass(Class<T> typeClass) {
        this.genericTypeClass = typeClass;
    }

    @Override
    public List<T> parseCsv(Path csvFile) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = Files.newBufferedReader(csvFile);){
            CsvToBean csvToBean = null;
            csvToBean = new CsvToBeanBuilder((Reader)reader).withSkipLines(this.getLinesToSkip()).withType(this.genericTypeClass).build();
            return csvToBean.parse();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected abstract int getLinesToSkip();

    @Override
    public void saveCsv(IFile csvFile, List<T> beansToSave) {
        File newFile = new File(csvFile.getLocationURI());
        if (!csvFile.exists()) {
            try {
                newFile.createNewFile();
            }
            catch (IOException e) {
                Logger.log(e);
            }
        }
        try {
            Throwable e = null;
            Object var5_8 = null;
            try (FileWriter writer = new FileWriter(newFile);){
                StatefulBeanToCsv sbc = new StatefulBeanToCsvBuilder((Writer)writer).withQuotechar('\u0000').withSeparator(',').build();
                this.writeDefaultCsvHeader(writer);
                if (beansToSave.isEmpty()) {
                    this.writeDefaultValues(writer);
                } else {
                    sbc.write(beansToSave);
                }
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (CsvDataTypeMismatchException | CsvRequiredFieldEmptyException | IOException e) {
            Logger.log((Exception)e);
        }
    }

    protected abstract void writeDefaultCsvHeader(Writer var1);

    protected abstract void writeDefaultValues(Writer var1);
}

