/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.tools;

import com.espressif.idf.core.tools.JsonKey;
import com.espressif.idf.core.tools.vo.ToolsVO;
import com.espressif.idf.core.tools.vo.VersionDetailsVO;
import com.espressif.idf.core.tools.vo.VersionsVO;
import com.espressif.idf.core.util.IDFUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Platform;

public class ToolsJsonParser {
    private Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private List<ToolsVO> toolsList = new ArrayList<ToolsVO>();
    private List<ToolsVO> requiredToolsList = new ArrayList<ToolsVO>();
    private static final String[] REQUIRED_TOOLS = new String[]{"cmake", "dfu-util", "ninja"};

    public void loadJson() throws Exception {
        this.toolsList.clear();
        JsonReader jsonReader = new JsonReader((Reader)new FileReader(IDFUtil.getIDFToolsJsonFileForInstallation()));
        JsonObject jsonObject = (JsonObject)this.gson.fromJson(jsonReader, JsonObject.class);
        JsonArray jsonArray = jsonObject.get("tools").getAsJsonArray();
        List<String> reqToolsNamesList = Arrays.asList(REQUIRED_TOOLS);
        int i = 0;
        while (i < jsonArray.size()) {
            JsonObject toolsJsonObject = jsonArray.get(i).getAsJsonObject();
            ToolsVO toolsVO = new ToolsVO();
            toolsVO.setDescription(toolsJsonObject.get("description").getAsString());
            if (toolsJsonObject.get("export_paths").getAsJsonArray().size() > 0) {
                toolsVO.setExportPaths(this.getStringsListFromJsonArray(toolsJsonObject.get("export_paths").getAsJsonArray().get(0).getAsJsonArray()));
            }
            toolsVO.setExportVars(this.getExportVarsMapFromJsonObject(toolsJsonObject.get("export_vars").getAsJsonObject()));
            toolsVO.setInfoUrl(toolsJsonObject.get("info_url").getAsString());
            toolsVO.setInstallType(toolsJsonObject.get("install").getAsString());
            toolsVO.setLicesnse(toolsJsonObject.get("license").getAsString());
            toolsVO.setName(toolsJsonObject.get("name").getAsString());
            if (toolsJsonObject.get("supported_targets") != null) {
                toolsVO.setSupportedTargets(this.getStringsListFromJsonArray(toolsJsonObject.get("supported_targets").getAsJsonArray()));
            }
            toolsVO.setVersionCmd(this.getStringsListFromJsonArray(toolsJsonObject.get("version_cmd").getAsJsonArray()));
            toolsVO.setVersionRegex(toolsJsonObject.get("version_regex").getAsString());
            toolsVO.setVersionVO(this.getVersions(toolsJsonObject.get("versions").getAsJsonArray()));
            toolsVO.setVersion(jsonObject.get("version").getAsString());
            JsonElement jsonElement = toolsJsonObject.get("platform_overrides");
            if (jsonElement != null) {
                this.adjustPlatformOverrides(jsonElement.getAsJsonArray(), toolsVO);
            }
            this.toolsList.add(toolsVO);
            if (reqToolsNamesList.contains(toolsVO.getName())) {
                this.requiredToolsList.add(toolsVO);
            }
            ++i;
        }
    }

    private void adjustPlatformOverrides(JsonArray jsonArray, ToolsVO toolsVO) throws Exception {
        String currentOS = Platform.getOS();
        if (currentOS.equals("win32")) {
            currentOS = "win";
        }
        if (currentOS.contains("macosx")) {
            Process p = Runtime.getRuntime().exec("uname -m");
            InputStreamReader inputStreamReader = new InputStreamReader(p.getInputStream());
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String output = bufferedReader.readLine();
            if (!output.contains("arm64")) {
                currentOS = "macos";
            } else {
                currentOS = "macos-".concat(output);
                inputStreamReader.close();
                bufferedReader.close();
            }
        }
        int i = 0;
        while (i < jsonArray.size()) {
            JsonObject jsonObject = jsonArray.get(i).getAsJsonObject();
            JsonArray platformArray = jsonObject.get("platforms").getAsJsonArray();
            int j = 0;
            while (j < platformArray.size()) {
                String platform = platformArray.get(j).getAsString();
                if (platform.contains(currentOS)) {
                    Set keys = jsonObject.keySet();
                    keys.remove("platforms");
                    for (String key : keys) {
                        JsonElement element = jsonObject.get(key);
                        if (element.isJsonArray()) {
                            List<String> list = this.getStringsListFromJsonArray(element.getAsJsonArray().get(0).getAsJsonArray());
                            this.injectOverride(toolsVO, key, list);
                            continue;
                        }
                        this.injectOverride(toolsVO, key, element.getAsString());
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void injectOverride(ToolsVO toolsVO, String key, Object val) throws Exception {
        Field[] allFields;
        Field[] fieldArray = allFields = ToolsVO.class.getDeclaredFields();
        int n = allFields.length;
        int n2 = 0;
        while (n2 < n) {
            JsonKey ann;
            Field field = fieldArray[n2];
            if (field.isAnnotationPresent(JsonKey.class) && (ann = field.getAnnotation(JsonKey.class)).key_name().equals(key)) {
                field.trySetAccessible();
                field.set(toolsVO, val);
                return;
            }
            ++n2;
        }
    }

    private List<VersionsVO> getVersions(JsonArray jsonArray) {
        ArrayList<VersionsVO> versionsVOs = new ArrayList<VersionsVO>();
        int i = 0;
        while (i < jsonArray.size()) {
            JsonObject jsonObject = jsonArray.get(i).getAsJsonObject();
            VersionsVO versionsVO = new VersionsVO();
            HashMap<String, VersionDetailsVO> versionDetailMap = new HashMap<String, VersionDetailsVO>();
            for (String key : jsonObject.keySet()) {
                if (key.equalsIgnoreCase("name") || key.equalsIgnoreCase("status")) continue;
                VersionDetailsVO versionDetailsVO = new VersionDetailsVO();
                JsonObject osVersionDetailsObject = jsonObject.get(key).getAsJsonObject();
                versionDetailsVO.setSha256(osVersionDetailsObject.get("sha256").getAsString());
                versionDetailsVO.setSize(osVersionDetailsObject.get("size").getAsDouble());
                versionDetailsVO.setUrl(osVersionDetailsObject.get("url").getAsString());
                versionDetailMap.put(key, versionDetailsVO);
            }
            versionsVO.setName(jsonObject.get("name").getAsString());
            versionsVO.setStatus(jsonObject.get("status").getAsString());
            versionsVO.setVersionOsMap(versionDetailMap);
            versionsVOs.add(versionsVO);
            ++i;
        }
        return versionsVOs;
    }

    private List<String> getStringsListFromJsonArray(JsonArray jsonArray) {
        ArrayList<String> stringList = new ArrayList<String>();
        if (jsonArray == null) {
            return stringList;
        }
        int i = 0;
        while (i < jsonArray.size()) {
            stringList.add(jsonArray.get(i).getAsString());
            ++i;
        }
        return stringList;
    }

    private Map<String, String> getExportVarsMapFromJsonObject(JsonObject exportVars) {
        HashMap<String, String> exportVarMap = new HashMap<String, String>();
        for (String key : exportVars.keySet()) {
            exportVarMap.put(key, exportVars.get(key).getAsString());
        }
        return exportVarMap;
    }

    public List<ToolsVO> getToolsList() {
        return this.toolsList;
    }

    public List<ToolsVO> getRequiredToolsList() {
        return this.requiredToolsList;
    }
}

