/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.toolchain;

import com.espressif.idf.core.DefaultBoardProvider;
import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.IDFEnvironmentVariables;
import com.espressif.idf.core.ProcessBuilderFactory;
import com.espressif.idf.core.build.Messages;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.toolchain.ESPToolChainElement;
import com.espressif.idf.core.toolchain.ESPToolchain;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.cmake.core.ICMakeToolChainFile;
import org.eclipse.cdt.cmake.core.ICMakeToolChainManager;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.cdt.core.build.IToolChainProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.ILaunchTargetManager;
import org.eclipse.launchbar.core.target.ILaunchTargetWorkingCopy;

public class ESPToolChainManager {
    private static final String TOOLCHAIN_ATTR_ID = "ATTR_ID";
    private String envValue;
    private static Map<String, ESPToolChainElement> toolchainElements = new HashMap<String, ESPToolChainElement>();

    public ESPToolChainManager() {
        ESPToolChainManager.readESPToolchainRegistry();
    }

    private static Map<String, ESPToolChainElement> readESPToolchainRegistry() {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.espressif.idf.core.toolchain");
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            String name = iConfigurationElement.getAttribute("name");
            String id = iConfigurationElement.getAttribute("id");
            String arch = iConfigurationElement.getAttribute("arch");
            String fileName = iConfigurationElement.getAttribute("fileName");
            String compilerPattern = iConfigurationElement.getAttribute("compilerPattern");
            String debuggerPatten = iConfigurationElement.getAttribute("debuggerPattern");
            String uniqueToolChainId = name.concat("/").concat(arch).concat("/").concat(fileName);
            toolchainElements.put(uniqueToolChainId, new ESPToolChainElement(name, id, arch, fileName, compilerPattern, debuggerPatten));
            ++n2;
        }
        return toolchainElements;
    }

    public void initToolChain(IToolChainManager manager, String toolchainId) {
        try {
            IToolChainProvider provider = manager.getProvider(toolchainId);
            this.initToolChain(manager, provider);
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
    }

    public void initToolChain(IToolChainManager manager, IToolChainProvider toolchainProvider) {
        String idfToolsExportPath;
        Logger.log("Initializing toolchain...");
        List<Object> paths = new ArrayList<String>();
        String string = idfToolsExportPath = StringUtil.isEmpty(this.envValue) ? this.getIdfToolsExportPath() : this.envValue;
        if (idfToolsExportPath != null) {
            paths.add(idfToolsExportPath);
        } else {
            paths = this.getAllPaths();
        }
        Logger.log(paths.toString());
        String idfPath = IDFUtil.getIDFPath();
        for (ESPToolChainElement toolChainElement : toolchainElements.values()) {
            File toolchainCompilerFile = this.findToolChain(paths, toolChainElement.compilerPattern);
            java.nio.file.Path toolChainCmakeFile = Paths.get(this.getIdfCMakePath(idfPath), new String[0]).resolve(toolChainElement.fileName);
            if (toolchainCompilerFile == null || !Files.exists(toolChainCmakeFile, new LinkOption[0])) continue;
            this.addToolChain(manager, toolchainProvider, toolchainCompilerFile, toolChainElement);
        }
    }

    public File findDebugger(String target) {
        return toolchainElements.values().stream().filter(espToolChainElement -> espToolChainElement.name.equals(target)).map(espToolChainElement -> this.findToolChain(this.getAllPaths(), espToolChainElement.debuggerPattern)).findFirst().orElse(null);
    }

    public File findCompiler(String target) {
        return toolchainElements.values().stream().filter(espToolChainElement -> espToolChainElement.name.equals(target)).map(espToolChainElement -> this.findToolChain(this.getAllPaths(), espToolChainElement.compilerPattern)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public File findToolChain(List<String> paths, String filePattern) {
        for (String path : paths) {
            java.nio.file.Path[] directories;
            java.nio.file.Path[] pathArray = directories = this.getDirectories(path);
            int n = directories.length;
            int n2 = 0;
            while (n2 < n) {
                java.nio.file.Path dir = pathArray[n2];
                File file = this.findMatchingFile(dir, filePattern);
                if (file != null) {
                    return file;
                }
                ++n2;
            }
        }
        return null;
    }

    private java.nio.file.Path[] getDirectories(String path2) {
        return (java.nio.file.Path[])Arrays.stream(path2.split(File.pathSeparator)).map(String::trim).map(string -> Paths.get(string, new String[0])).filter(path -> Files.exists(path, new LinkOption[0])).toArray(java.nio.file.Path[]::new);
    }

    private File findMatchingFile(java.nio.file.Path dir, String filePattern) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (DirectoryStream<java.nio.file.Path> stream = Files.newDirectoryStream(dir);){
                Pattern pattern = Pattern.compile(filePattern);
                for (java.nio.file.Path file : stream) {
                    Matcher matcher;
                    if (!Files.isRegularFile(file, new LinkOption[0]) || !(matcher = pattern.matcher(file.toAbsolutePath().toString())).find()) continue;
                    return file.toFile();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Logger.log(e);
        }
        return null;
    }

    public void removePrevInstalledToolchains(IToolChainManager manager) {
        try {
            Collection toolchains = manager.getAllToolChains();
            ArrayList<IToolChain> tcList = new ArrayList<IToolChain>(toolchains);
            tcList.forEach(arg_0 -> ((IToolChainManager)manager).removeToolChain(arg_0));
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
    }

    private void addToolChain(IToolChainManager manager, IToolChainProvider toolchainProvider, File compilerFile, ESPToolChainElement toolChainElement) {
        try {
            if (this.isToolChainExist(manager, toolChainElement)) {
                this.removeMatchedToolChain(manager, toolChainElement);
            }
            manager.addToolChain((IToolChain)new ESPToolchain(toolchainProvider, compilerFile.toPath(), toolChainElement));
        }
        catch (CoreException e) {
            CCorePlugin.log((IStatus)e.getStatus());
        }
    }

    private void removeMatchedToolChain(IToolChainManager manager, ESPToolChainElement toolChainElement) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("os", toolChainElement.name);
        props.put("arch", toolChainElement.arch);
        props.put(TOOLCHAIN_ATTR_ID, toolChainElement.fileName);
        try {
            manager.getToolChainsMatching(props).forEach(arg_0 -> ((IToolChainManager)manager).removeToolChain(arg_0));
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
    }

    private boolean isToolChainExist(IToolChainManager manager, ESPToolChainElement toolChainElement) throws CoreException {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("os", toolChainElement.name);
        props.put("arch", toolChainElement.arch);
        props.put(TOOLCHAIN_ATTR_ID, toolChainElement.fileName);
        return !manager.getToolChainsMatching(props).isEmpty();
    }

    protected List<String> getAllPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        String path = new IDFEnvironmentVariables().getEnvValue("PATH");
        if (!StringUtil.isEmpty(path)) {
            paths.add(path);
        }
        if (!StringUtil.isEmpty(path = System.getenv("PATH"))) {
            paths.add(path);
        }
        paths.removeIf(Objects::isNull);
        return paths;
    }

    protected String getIdfToolsExportPath() {
        String idfPath = IDFUtil.getIDFPath();
        String toolsPath = idfPath + "/tools/idf_tools.py";
        Logger.log("idf_tools.py path: " + toolsPath);
        if (!new File(toolsPath).exists()) {
            Logger.log("idf_tools.py path doesn't exist");
            return null;
        }
        String idfPythonEnvPath = IDFUtil.getIDFPythonEnvPath();
        try {
            ArrayList<String> commands = new ArrayList<String>();
            if (!StringUtil.isEmpty(idfPythonEnvPath)) {
                commands.add(idfPythonEnvPath);
            }
            commands.add(toolsPath);
            commands.add("export");
            commands.add("--format=key-value");
            Logger.log(((Object)commands).toString());
            IStatus idfToolsExportStatus = new ProcessBuilderFactory().runInBackground(commands, (IPath)Path.ROOT, IDFUtil.getSystemEnv());
            if (idfToolsExportStatus != null && idfToolsExportStatus.isOK()) {
                String message = idfToolsExportStatus.getMessage();
                Logger.log("idf_tools.py export output: " + message);
                if (message != null) {
                    String[] exportEntries;
                    String[] stringArray = exportEntries = message.split("\n");
                    int n = exportEntries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String entry = stringArray[n2];
                        String[] keyValue = entry.split("=");
                        if (keyValue.length == 2 && keyValue[0].equals("PATH")) {
                            Logger.log("PATH: " + keyValue[1]);
                            return keyValue[1];
                        }
                        ++n2;
                    }
                }
            }
        }
        catch (Exception e) {
            Logger.log(IDFCorePlugin.getPlugin(), e);
        }
        return null;
    }

    public void initCMakeToolChain(ICMakeToolChainManager manager) {
        String idfPath = IDFUtil.getIDFPath();
        if (StringUtil.isEmpty(idfPath)) {
            Logger.log("IDF_PATH is not found to auto-configure the toolchains.");
            return;
        }
        if (!new File(idfPath).exists()) {
            String msg = MessageFormat.format(Messages.ESP32CMakeToolChainProvider_PathDoesnNotExist, idfPath);
            Logger.log(msg);
            return;
        }
        IDFEnvironmentVariables idfEnvMgr = new IDFEnvironmentVariables();
        if (!new File(idfEnvMgr.getEnvValue("IDF_PATH")).exists()) {
            idfEnvMgr.addEnvVariable("IDF_PATH", idfPath);
        }
        toolchainElements.values().stream().forEach(value -> {
            java.nio.file.Path toolChainFile = Paths.get(this.getIdfCMakePath(idfPath), new String[0]).resolve(value.fileName);
            if (Files.exists(toolChainFile, new LinkOption[0])) {
                ICMakeToolChainFile toolchainFile = manager.newToolChainFile(toolChainFile);
                toolchainFile.setProperty("os", value.name);
                toolchainFile.setProperty("arch", value.arch);
                toolchainFile.setProperty("cdt.toolChain.type", "org.eclipse.cdt.build.gcc");
                toolchainFile.setProperty("cdt.toolChain.id", value.id);
                try {
                    if (toolchainFile.getToolChain() != null) {
                        manager.addToolChainFile(toolchainFile);
                    }
                }
                catch (CoreException e) {
                    Logger.log((Exception)((Object)e));
                }
            }
        });
    }

    public Collection<Map<String, String>> getToolchainProperties(Map<String, ESPToolChainElement> map) {
        ArrayList<Map<String, String>> propertiesList = new ArrayList<Map<String, String>>();
        for (ESPToolChainElement toolChainElement : map.values()) {
            HashMap<String, String> esp = new HashMap<String, String>();
            esp.put("os", toolChainElement.name);
            esp.put("arch", toolChainElement.arch);
            esp.put(TOOLCHAIN_ATTR_ID, toolChainElement.fileName);
            propertiesList.add(esp);
        }
        return propertiesList;
    }

    public List<String> getAvailableEspTargetList() {
        HashSet<String> targetSet = new HashSet<String>();
        for (IToolChain toolchain : this.getAllEspToolchains()) {
            targetSet.add(toolchain.getProperty("os"));
        }
        return targetSet.stream().toList();
    }

    public Collection<IToolChain> getAllEspToolchains() {
        IToolChainManager tcManager = (IToolChainManager)CCorePlugin.getService(IToolChainManager.class);
        Collection<Object> toolchains = Collections.emptyList();
        try {
            toolchains = tcManager.getAllToolChains();
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
        return toolchains.stream().filter(tc -> tc.getProperty("os").contains("esp")).toList();
    }

    public void addToolchainBasedTargets(ILaunchTargetManager targetManager) {
        List<IToolChain> toolchainsWithoutDuplicateTargets = this.getAllEspToolchains().stream().filter(this.distinctByOs(tc -> tc.getProperty("os"))).toList();
        try {
            this.addLaunchTargets(targetManager, toolchainsWithoutDuplicateTargets);
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    public void addToolchainBasedTargets(ILaunchTargetManager targetManager, List<String> targets) {
        List<IToolChain> toolchainsWithoutDuplicateTargets = this.getAllEspToolchains().stream().filter(this.distinctByOs(tc -> tc.getProperty("os"))).toList();
        try {
            this.addLaunchTargets(targetManager, toolchainsWithoutDuplicateTargets, targets);
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    private <T> Predicate<T> distinctByOs(Function<? super T, Object> extractor) {
        HashSet osSet = new HashSet();
        return t -> osSet.add(extractor.apply(t));
    }

    private void addLaunchTargets(ILaunchTargetManager targetManager, Collection<IToolChain> toolchainsWithoutDuplicateTargets) throws SecurityException, IllegalArgumentException {
        for (IToolChain toolchain : toolchainsWithoutDuplicateTargets) {
            String os = toolchain.getProperty("os");
            String arch = toolchain.getProperty("arch");
            if (targetManager.getLaunchTarget("com.espressif.idf.launch.serial.core.serialFlashTarget", os) != null) continue;
            ILaunchTarget target = targetManager.addLaunchTarget("com.espressif.idf.launch.serial.core.serialFlashTarget", os);
            ILaunchTargetWorkingCopy wc = target.getWorkingCopy();
            wc.setAttribute("os", os);
            wc.setAttribute("arch", arch);
            wc.setAttribute("com.espressif.idf.launch.serial.core.idfTarget", os);
            wc.setAttribute("com.espressif.idf.launch.serial.core.flash_voltage", "default");
            wc.setAttribute("com.espressif.idf.launch.serial.core.board", new DefaultBoardProvider().getDefaultBoard(os));
            wc.save();
        }
        this.addLaunchTargets(targetManager, toolchainsWithoutDuplicateTargets, null);
    }

    private void addLaunchTargets(ILaunchTargetManager targetManager, Collection<IToolChain> toolchainsWithoutDuplicateTargets, List<String> targets) throws SecurityException, IllegalArgumentException {
        String os;
        List<IToolChain> toolChainsToRemove = null;
        List<IToolChain> toolChainsToUse = null;
        if (targets != null) {
            toolChainsToRemove = toolchainsWithoutDuplicateTargets.stream().filter(tc -> !targets.contains(tc.getProperty("os"))).toList();
            toolChainsToUse = toolchainsWithoutDuplicateTargets.stream().filter(tc -> targets.contains(tc.getProperty("os"))).toList();
            for (IToolChain toolChain : toolChainsToRemove) {
                os = toolChain.getProperty("os");
                ILaunchTarget target = targetManager.getLaunchTarget("com.espressif.idf.launch.serial.core.serialFlashTarget", os);
                if (target == null) continue;
                targetManager.removeLaunchTarget(target);
            }
        } else {
            toolChainsToUse = toolchainsWithoutDuplicateTargets.stream().toList();
        }
        for (IToolChain toolchain : toolChainsToUse) {
            os = toolchain.getProperty("os");
            String arch = toolchain.getProperty("arch");
            if (targetManager.getLaunchTarget("com.espressif.idf.launch.serial.core.serialFlashTarget", os) != null) continue;
            ILaunchTarget target = targetManager.addLaunchTarget("com.espressif.idf.launch.serial.core.serialFlashTarget", os);
            ILaunchTargetWorkingCopy wc = target.getWorkingCopy();
            wc.setAttribute("os", os);
            wc.setAttribute("arch", arch);
            wc.setAttribute("com.espressif.idf.launch.serial.core.idfTarget", os);
            wc.setAttribute("com.espressif.idf.launch.serial.core.flash_voltage", "default");
            wc.setAttribute("com.espressif.idf.launch.serial.core.board", new DefaultBoardProvider().getDefaultBoard(os));
            wc.save();
        }
    }

    protected String getIdfCMakePath(String idfPath) {
        return idfPath + "/tools/cmake";
    }

    public void configureToolChain() {
        IToolChainManager tcManager = (IToolChainManager)CCorePlugin.getService(IToolChainManager.class);
        ICMakeToolChainManager cmakeTcManager = (ICMakeToolChainManager)CCorePlugin.getService(ICMakeToolChainManager.class);
        this.initToolChain(tcManager, "com.espressif.idf.core.esp.toolchainprovider");
        this.initCMakeToolChain(cmakeTcManager);
        this.addToolchainBasedTargets(IDFCorePlugin.getService(ILaunchTargetManager.class));
    }

    public void configureToolChain(List<String> targets) {
        IToolChainManager tcManager = (IToolChainManager)CCorePlugin.getService(IToolChainManager.class);
        ICMakeToolChainManager cmakeTcManager = (ICMakeToolChainManager)CCorePlugin.getService(ICMakeToolChainManager.class);
        this.initToolChain(tcManager, "com.espressif.idf.core.esp.toolchainprovider");
        this.initCMakeToolChain(cmakeTcManager);
        this.addToolchainBasedTargets(IDFCorePlugin.getService(ILaunchTargetManager.class), targets);
    }

    public void removeLaunchTargetsNotPresent(List<String> targetsToKeep) {
        ILaunchTarget[] launchTargets;
        ILaunchTargetManager targetManager = IDFCorePlugin.getService(ILaunchTargetManager.class);
        ILaunchTarget[] iLaunchTargetArray = launchTargets = targetManager.getLaunchTargets();
        int n = launchTargets.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchTarget launchTarget = iLaunchTargetArray[n2];
            if (!targetsToKeep.contains(launchTarget.getId())) {
                targetManager.removeLaunchTarget(launchTarget);
            }
            ++n2;
        }
    }

    public void removeCmakeToolChains() {
        ICMakeToolChainManager cmakeTcManager = (ICMakeToolChainManager)CCorePlugin.getService(ICMakeToolChainManager.class);
        ArrayList cIcMakeToolChainFiles = new ArrayList(cmakeTcManager.getToolChainFiles());
        for (ICMakeToolChainFile cmakeToolchain : cIcMakeToolChainFiles) {
            cmakeTcManager.removeToolChainFile(cmakeToolchain);
        }
    }

    public void removeStdToolChains() {
        IToolChainManager tcManager = (IToolChainManager)CCorePlugin.getService(IToolChainManager.class);
        try {
            ArrayList espToolchains = new ArrayList(tcManager.getAllToolChains());
            for (IToolChain espToolChain : espToolchains) {
                if (StringUtil.isEmpty(espToolChain.getTypeId())) continue;
                tcManager.removeToolChain(espToolChain);
            }
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
        }
    }

    public List<ESPToolchain> getStdToolChains(List<String> paths, String idfPath) throws CoreException {
        ArrayList<ESPToolchain> espToolchains = new ArrayList<ESPToolchain>();
        IToolChainManager manager = (IToolChainManager)CCorePlugin.getService(IToolChainManager.class);
        IToolChainProvider toolchainProvider = manager.getProvider("com.espressif.idf.core.esp.toolchainprovider");
        for (ESPToolChainElement toolChainElement : toolchainElements.values()) {
            File toolchainCompilerFile = this.findToolChain(paths, toolChainElement.compilerPattern);
            java.nio.file.Path toolChainCmakeFile = Paths.get(this.getIdfCMakePath(idfPath), new String[0]).resolve(toolChainElement.fileName);
            if (toolchainCompilerFile == null || !Files.exists(toolChainCmakeFile, new LinkOption[0])) continue;
            espToolchains.add(new ESPToolchain(toolchainProvider, toolchainCompilerFile.toPath(), toolChainElement));
        }
        return espToolchains;
    }

    public List<ICMakeToolChainFile> getCmakeToolChains(String idfPath) {
        ArrayList<ICMakeToolChainFile> espToolchains = new ArrayList<ICMakeToolChainFile>();
        ICMakeToolChainManager manager = (ICMakeToolChainManager)CCorePlugin.getService(ICMakeToolChainManager.class);
        toolchainElements.values().stream().forEach(value -> {
            java.nio.file.Path toolChainFile = Paths.get(this.getIdfCMakePath(idfPath), new String[0]).resolve(value.fileName);
            if (Files.exists(toolChainFile, new LinkOption[0])) {
                ICMakeToolChainFile toolchainFile = manager.newToolChainFile(toolChainFile);
                toolchainFile.setProperty("os", value.name);
                toolchainFile.setProperty("arch", value.arch);
                toolchainFile.setProperty("cdt.toolChain.type", "org.eclipse.cdt.build.gcc");
                toolchainFile.setProperty("cdt.toolChain.id", value.id);
                espToolchains.add(toolchainFile);
            }
        });
        return espToolchains;
    }
}

