/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer;

import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerHtmlReport;
import org.eclipse.nebula.widgets.xviewer.XViewerText;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.nebula.widgets.xviewer.util.XViewerException;

public class XViewerLoadingReport
extends XViewerHtmlReport {
    protected final XViewer xViewer;
    protected final String title;

    public XViewerLoadingReport(String title, XViewer treeViewer) {
        super(title);
        this.title = title;
        this.xViewer = treeViewer;
    }

    public XViewerLoadingReport(XViewer xViewer) {
        this(XViewerText.get("XViewerLoadingReport.title"), xViewer);
    }

    @Override
    public void open(String defaultFilename) {
        super.open(defaultFilename);
    }

    @Override
    public String getHtml() throws XViewerException {
        Long min;
        Long sec;
        Long ms;
        StringBuilder sb = new StringBuilder("<html><body>");
        List<XViewerColumn> columns = this.xViewer.getCustomizeMgr().getCurrentTableColumnsInOrder();
        sb.append("</br>PRE-COMPUTED</br>");
        for (Map.Entry<String, Long> nameToTime : this.xViewer.getPreComputeElapsedTime().entrySet()) {
            ms = nameToTime.getValue();
            sec = ms > 0L ? ms / 1000L : 0L;
            min = sec > 0L ? sec / 60L : 0L;
            sb.append(String.format("%s min or %s sec or %s ms - <b>%s</b></br>", min, sec, ms, nameToTime.getKey()));
        }
        sb.append("</br>OTHER</br>");
        for (XViewerColumn xCol : columns) {
            if (!xCol.isShow()) continue;
            ms = xCol.getElapsedTime();
            sec = ms > 0L ? ms / 1000L : 0L;
            min = sec > 0L ? sec / 60L : 0L;
            sb.append(String.format("%s min or %s sec or %s ms - <b>%s</b></br>", min, sec, ms, xCol.getName()));
        }
        sb.append("</body></html>");
        return sb.toString();
    }
}

