/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.tracing.heaptracing;

import com.espressif.idf.ui.tracing.EventsVO;
import com.espressif.idf.ui.tracing.Messages;
import com.espressif.idf.ui.tracing.TracingJsonParser;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class HeapTracingOverviewComposite {
    private TracingJsonParser tracingJsonParser;
    private FormToolkit toolkit;
    private Composite detailsComp;
    private Composite chartComp;
    private Button refreshGraphBtn;
    private Form form;
    private Section chartSection;
    private Section detailsSection;
    private Chart chart;
    private Set<ContextEventData> contextDatasList;
    private List<Button> contextChkButtons;
    private Group contextNamesGroup;

    public HeapTracingOverviewComposite(TracingJsonParser tracingJsonParser) {
        this.tracingJsonParser = tracingJsonParser;
    }

    public void createPartControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createForm(parent);
        this.toolkit.decorateFormHeading(this.form);
        List filteredEvents = this.tracingJsonParser.getEventsVOs().stream().filter(event -> event.getEventId() == this.tracingJsonParser.getAllocEventId() || event.getEventId() == this.tracingJsonParser.getFreeEventId()).collect(Collectors.toList());
        Double currentSum = 0.0;
        ArrayList<Double> eventMemoryUsage = new ArrayList<Double>();
        for (EventsVO filteredEvent : filteredEvents) {
            if (filteredEvent.getEventId() == this.tracingJsonParser.getFreeEventId()) {
                Optional<EventsVO> foundEvent = filteredEvents.stream().filter(eventVo -> eventVo.getEventId() == this.tracingJsonParser.getAllocEventId() && eventVo.getAddressOfAllocatedMemoryBlock().equals(filteredEvent.getAddressOfAllocatedMemoryBlock())).findAny();
                if (foundEvent.isPresent()) {
                    currentSum = currentSum - (double)foundEvent.get().getSizeOfAllocatedMemoryBlock();
                }
            } else {
                currentSum = currentSum + (double)filteredEvent.getSizeOfAllocatedMemoryBlock();
            }
            eventMemoryUsage.add(currentSum);
        }
        double[] allocEventsMemoryUsage = new double[eventMemoryUsage.size()];
        int i = 0;
        while (i < eventMemoryUsage.size()) {
            allocEventsMemoryUsage[i] = (Double)eventMemoryUsage.get(i);
            ++i;
        }
        this.form.setText(Messages.TracingAnalysisEditor_OverviewFromHeading);
        this.form.getBody().setLayout((Layout)new GridLayout());
        this.createDetailsCompositeSection();
        this.chartSection = this.toolkit.createSection(this.form.getBody(), 256);
        this.chartSection.setText(Messages.TracingAnalysisEditor_OverviewChartSectionHeading);
        this.chartSection.setLayoutData((Object)new GridData(4, 4, true, true));
        this.chartComp = new Composite((Composite)this.chartSection, 0);
        this.chartComp.setLayout((Layout)new GridLayout(2, false));
        this.chartComp.setBackground(this.form.getBody().getBackground());
        this.chartComp.setForeground(this.form.getBody().getForeground());
        this.chartSection.setClient((Control)this.chartComp);
        this.createChart(this.chartComp, allocEventsMemoryUsage);
    }

    private void createDetailsCompositeSection() {
        this.detailsSection = this.toolkit.createSection(this.form.getBody(), 256);
        this.detailsSection.setText(Messages.TracingAnalysisEditor_OverviewDetailSectionHeading);
        this.detailsSection.setLayoutData((Object)new GridData(4, 0, true, false));
        this.detailsComp = new Composite((Composite)this.detailsSection, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        this.detailsComp.setLayout((Layout)gridLayout);
        this.detailsComp.setBackground(this.form.getBody().getBackground());
        this.detailsComp.setForeground(this.form.getBody().getForeground());
        Set contextNames = this.tracingJsonParser.getAllocEvents().stream().map(eventVo -> eventVo.getContextName()).collect(Collectors.toSet());
        this.contextNamesGroup = new Group(this.detailsComp, 528);
        this.contextNamesGroup.setText("Available Context Names");
        this.contextNamesGroup.setSize(200, 100);
        this.contextNamesGroup.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 5, 1));
        this.contextNamesGroup.setLayout((Layout)new GridLayout(1, false));
        this.contextChkButtons = new ArrayList<Button>();
        Button allContextsChkButton = new Button((Composite)this.contextNamesGroup, 32);
        allContextsChkButton.setText(Messages.TracingAnalysisEditor_OverviewDetailSectionAllContexts);
        this.contextChkButtons.add(allContextsChkButton);
        for (String contextName : contextNames) {
            Button contextChkButton = new Button((Composite)this.contextNamesGroup, 32);
            contextChkButton.setText(contextName);
            this.contextChkButtons.add(contextChkButton);
        }
        this.refreshGraphBtn = new Button(this.detailsComp, 8);
        this.refreshGraphBtn.setText("Refresh Graph");
        this.refreshGraphBtn.addSelectionListener((SelectionListener)new RefreshGraphSelectionAdapter());
        this.detailsSection.setClient((Control)this.detailsComp);
    }

    private void createChartWithMultipleEvents(Set<ContextEventData> contextEventsData) {
        ISeries[] seriesInChart;
        ISeries[] iSeriesArray = seriesInChart = this.chart.getSeriesSet().getSeries();
        int n = seriesInChart.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries series = iSeriesArray[n2];
            this.chart.getSeriesSet().deleteSeries(series.getId());
            ++n2;
        }
        this.chart.getTitle().setText(Messages.TracingAnalysisEditor_OverviewChartSectionMultiChartHeading);
        this.chart.getAxisSet().getXAxis(0).getTitle().setText("");
        this.chart.getAxisSet().getYAxis(0).getTitle().setText(Messages.TracingAnalysisEditor_OverviewChartSectionYAxisTitle);
        for (ContextEventData contextData : contextEventsData) {
            ILineSeries lineSeriesEvents = (ILineSeries)this.chart.getSeriesSet().createSeries(ISeries.SeriesType.LINE, contextData.getContextName());
            lineSeriesEvents.setLineStyle(LineStyle.SOLID);
            lineSeriesEvents.setYSeries(contextData.getContextMemoryValsArray());
            lineSeriesEvents.setLineColor(this.getRandomColorForChart());
            lineSeriesEvents.setLineWidth(2);
            lineSeriesEvents.setSymbolType(ILineSeries.PlotSymbolType.NONE);
            lineSeriesEvents.setAntialias(1);
            lineSeriesEvents.enableArea(true);
        }
        this.chart.getAxisSet().getYAxis(0).enableLogScale(false);
        this.chart.getAxisSet().adjustRange();
        this.chart.redraw();
    }

    private Color getRandomColorForChart() {
        Random rand = new Random();
        int r = rand.nextInt(255);
        int g = rand.nextInt(255);
        int b = rand.nextInt(255);
        Color randomColor = new Color(r, g, b);
        return randomColor;
    }

    private void createChart(Composite parent, double[] allocEventsMemoryUsage) {
        this.chart = new Chart(parent, 0);
        this.chart.setLayoutData((Object)new GridData(4, 4, true, true));
        this.chart.getTitle().setText(Messages.TracingAnalysisEditor_OverviewChartSectionHeapChartHeading);
        this.chart.getAxisSet().getXAxis(0).getTitle().setText("");
        this.chart.getAxisSet().getYAxis(0).getTitle().setText(Messages.TracingAnalysisEditor_OverviewChartSectionYAxisTitle);
        ILineSeries lineSeriesAllocEvents = (ILineSeries)this.chart.getSeriesSet().createSeries(ISeries.SeriesType.LINE, "ALLOC EVENTS");
        lineSeriesAllocEvents.setLineStyle(LineStyle.SOLID);
        lineSeriesAllocEvents.setYSeries(allocEventsMemoryUsage);
        lineSeriesAllocEvents.setLineColor(new Color(255, 128, 0));
        lineSeriesAllocEvents.setLineWidth(2);
        lineSeriesAllocEvents.setSymbolColor(new Color(255, 255, 0));
        lineSeriesAllocEvents.setSymbolSize(4);
        lineSeriesAllocEvents.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        lineSeriesAllocEvents.setAntialias(1);
        lineSeriesAllocEvents.enableArea(true);
        lineSeriesAllocEvents.enableStep(false);
        this.chart.getAxisSet().getYAxis(0).enableLogScale(false);
        this.chart.getAxisSet().adjustRange();
    }

    private class ContextEventData {
        private String contextName;
        private List<Double> contextMemoryVals;
        private int eventId;
        private String eventName;
        private boolean isAllContexts;

        private ContextEventData() {
        }

        public List<Double> getContextMemoryVals() {
            return this.contextMemoryVals;
        }

        public double[] getContextMemoryValsArray() {
            double[] memoryVals = new double[this.contextMemoryVals.size()];
            int i = 0;
            while (i < this.contextMemoryVals.size()) {
                memoryVals[i] = this.contextMemoryVals.get(i);
                ++i;
            }
            return memoryVals;
        }

        public void setContextMemoryVals(List<Double> eventMemoryVals) {
            this.contextMemoryVals = eventMemoryVals;
        }

        public String getContextName() {
            return this.contextName;
        }

        public void setContextName(String eventName) {
            this.contextName = eventName;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ContextEventData) || !(object instanceof String)) {
                return false;
            }
            if (object instanceof ContextEventData) {
                ContextEventData eData = (ContextEventData)object;
                return eData.contextName.equals(this.contextName);
            }
            return this.contextName.equals(object);
        }

        public int hashCode() {
            return this.contextName.hashCode();
        }

        public int getEventId() {
            return this.eventId;
        }

        public void setEventId(int eventId) {
            this.eventId = eventId;
        }

        public String getEventName() {
            return this.eventName;
        }

        public void setEventName(String eventName) {
            this.eventName = eventName;
        }

        public boolean isAllContexts() {
            return this.isAllContexts;
        }

        public void setAllContexts(boolean isAllContexts) {
            this.isAllContexts = isAllContexts;
        }
    }

    private class RefreshGraphSelectionAdapter
    extends SelectionAdapter {
        private RefreshGraphSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            List selectedContextNamesFromAvailableList = HeapTracingOverviewComposite.this.contextChkButtons.stream().filter(btn -> btn.getSelection()).map(btn -> btn.getText()).collect(Collectors.toList());
            HeapTracingOverviewComposite.this.contextDatasList = new HashSet<ContextEventData>();
            int eventId = HeapTracingOverviewComposite.this.tracingJsonParser.getAllEventsNameIdMap().get("alloc");
            for (String contextName : selectedContextNamesFromAvailableList) {
                LinkedList<Double> eventMemoryUsage = new LinkedList<Double>();
                boolean setAllContext = false;
                double memorySum = 0.0;
                List<EventsVO> filteredEvents = HeapTracingOverviewComposite.this.tracingJsonParser.getEventsVOs().stream().filter(eventVo -> eventVo.getEventId() == eventId || eventVo.getEventId() == HeapTracingOverviewComposite.this.tracingJsonParser.getFreeEventId()).collect(Collectors.toList());
                if (contextName.equals(Messages.TracingAnalysisEditor_OverviewDetailSectionAllContexts)) {
                    for (EventsVO filteredEvent : filteredEvents) {
                        memorySum = this.getNextSeriesValue(memorySum, filteredEvent, filteredEvents);
                        eventMemoryUsage.add(memorySum);
                    }
                    setAllContext = true;
                } else {
                    filteredEvents = filteredEvents.stream().filter(fEvent -> fEvent.getContextName().equals(contextName) || fEvent.getEventId() == HeapTracingOverviewComposite.this.tracingJsonParser.getFreeEventId()).collect(Collectors.toList());
                    for (EventsVO filteredEvent : filteredEvents) {
                        memorySum = this.getNextSeriesValue(memorySum, filteredEvent, filteredEvents);
                        eventMemoryUsage.add(memorySum);
                    }
                }
                HeapTracingOverviewComposite.this.contextDatasList.add(this.getContextEventDataObjectForChart(contextName, eventMemoryUsage, eventId, "alloc", setAllContext));
            }
            HeapTracingOverviewComposite.this.createChartWithMultipleEvents(HeapTracingOverviewComposite.this.contextDatasList);
        }

        private ContextEventData getContextEventDataObjectForChart(String contextName, List<Double> contextMemorySeiies, int eventId, String eventName, boolean setAllContexts) {
            ContextEventData contextEventData = new ContextEventData();
            contextEventData.setContextName(contextName);
            contextEventData.setContextMemoryVals(contextMemorySeiies);
            contextEventData.setEventId(eventId);
            contextEventData.setEventName(eventName);
            contextEventData.setAllContexts(setAllContexts);
            return contextEventData;
        }

        private double getNextSeriesValue(double currentSum, EventsVO filteredEvent, List<EventsVO> filteredEvents) {
            if (filteredEvent.getEventId() == HeapTracingOverviewComposite.this.tracingJsonParser.getFreeEventId()) {
                Optional<EventsVO> foundEvent = filteredEvents.stream().filter(eventVo -> eventVo.getEventId() == HeapTracingOverviewComposite.this.tracingJsonParser.getAllocEventId() && eventVo.getAddressOfAllocatedMemoryBlock().equals(filteredEvent.getAddressOfAllocatedMemoryBlock())).findAny();
                if (foundEvent.isPresent()) {
                    currentSum -= (double)foundEvent.get().getSizeOfAllocatedMemoryBlock();
                }
            } else {
                currentSum += (double)filteredEvent.getSizeOfAllocatedMemoryBlock();
            }
            return currentSum;
        }
    }
}

