/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.tracing.heaptracing;

import com.espressif.idf.ui.tracing.Messages;
import com.espressif.idf.ui.tracing.TracingJsonParser;
import com.espressif.idf.ui.tracing.TracingSizeDataContentProvider;
import com.espressif.idf.ui.tracing.TracingViewerFactory;
import com.espressif.idf.ui.tracing.heaptracing.HeapTracingDataStyledLabelProvider;
import com.espressif.idf.ui.tracing.heaptracing.HeapTracingTreeViewer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class HeapTracingDetailsComposite {
    private TracingJsonParser tracingJsonParser;
    private List<String> columnNames;
    private HeapTracingTreeViewer tracingTreeViewer;

    public HeapTracingDetailsComposite(TracingJsonParser tracingJsonParser) {
        this.tracingJsonParser = tracingJsonParser;
        this.createColumnsList();
    }

    private void createColumnsList() {
        this.columnNames = new ArrayList<String>();
        this.columnNames.add(Messages.TracingAnalysisEditor_DetailsColTimestamp);
        this.columnNames.add(Messages.TracingAnalysisEditor_DetailsColEventId);
        this.columnNames.add(Messages.TracingAnalysisEditor_DetailsColCoreId);
        this.columnNames.add(Messages.TracingAnalysisEditor_DetailsColIsIrq);
        this.columnNames.add(Messages.TracingAnalysisEditor_DetailsColContextName);
        this.columnNames.add(Messages.TracingAnalysisEditor_DetailsEventName);
        this.columnNames.add(Messages.TracingAnalysisEditor_DetailsColSizeOfAllocatedBlock);
        this.columnNames.add(Messages.TracingAnalysisEditor_DetailsColAddress);
        this.columnNames.add(Messages.TracingAnalysisEditor_DetailsColCallers);
    }

    public void createPartControl(Composite parent) {
        Integer[] tracingEventIds = new Integer[]{this.tracingJsonParser.getAllocEventId(), this.tracingJsonParser.getFreeEventId()};
        TracingViewerFactory tracingViewerFactory = new TracingViewerFactory(this.tracingJsonParser);
        this.tracingTreeViewer = new HeapTracingTreeViewer(parent, 67588, this.tracingJsonParser, tracingEventIds, tracingViewerFactory);
        this.tracingTreeViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.tracingTreeViewer.setContentProvider((IContentProvider)new TracingSizeDataContentProvider());
        this.tracingTreeViewer.setLabelProvider((IBaseLabelProvider)new HeapTracingDataStyledLabelProvider(this.tracingTreeViewer, this.tracingJsonParser));
        this.tracingTreeViewer.setUseHashlookup(true);
        this.tracingTreeViewer.loadInputForXViewer();
    }
}

