/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.tracing.heaptracing;

import com.espressif.idf.ui.tracing.DetailsVO;
import com.espressif.idf.ui.tracing.TracingJsonParser;
import com.espressif.idf.ui.tracing.heaptracing.HeapTracingTreeViewer;
import com.espressif.idf.ui.tracing.images.TracingImagesCache;
import java.text.DecimalFormat;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerStyledTextLabelProvider;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class HeapTracingDataStyledLabelProvider
extends XViewerStyledTextLabelProvider {
    private HeapTracingTreeViewer tracingTreeViewer;
    private TracingJsonParser tracingJsonParser;

    public HeapTracingDataStyledLabelProvider(HeapTracingTreeViewer viewer, TracingJsonParser tracingJsonParser) {
        super((XViewer)viewer);
        this.tracingTreeViewer = this.tracingTreeViewer;
        this.tracingJsonParser = tracingJsonParser;
    }

    public Image getColumnImage(Object element, XViewerColumn xCol, int column) throws Exception {
        DetailsVO data = (DetailsVO)element;
        switch (column) {
            case 5: {
                if (data.getEventName().equals("alloc")) {
                    return TracingImagesCache.getImage("alloc".concat(".png"));
                }
                if (!data.getEventName().equals("free")) break;
                return TracingImagesCache.getImage("free".concat(".png"));
            }
        }
        return null;
    }

    public StyledString getStyledText(Object element, XViewerColumn xCol, int column) throws Exception {
        DetailsVO data = (DetailsVO)element;
        switch (column) {
            case 0: {
                DecimalFormat decimalFormat = new DecimalFormat("#.################");
                decimalFormat.setMaximumFractionDigits(30);
                return new StyledString(String.valueOf(decimalFormat.format(data.getEventsVO().getTimestampOfEvent())));
            }
            case 1: {
                return new StyledString(String.valueOf(data.getEventsVO().getEventId()));
            }
            case 2: {
                return new StyledString(String.valueOf(data.getEventsVO().getCoreId()));
            }
            case 3: {
                return new StyledString(String.valueOf(data.getEventsVO().isIRQ()));
            }
            case 4: {
                return new StyledString(String.valueOf(data.getEventsVO().getContextName()));
            }
            case 5: {
                return new StyledString(String.valueOf(data.getEventName()));
            }
            case 6: {
                return new StyledString(String.valueOf(data.getEventsVO().getSizeOfAllocatedMemoryBlock()));
            }
            case 7: {
                return new StyledString(String.valueOf(data.getEventsVO().getAddressOfAllocatedMemoryBlock()));
            }
        }
        return null;
    }

    public Color getBackground(Object element, XViewerColumn viewerColumn, int columnIndex) throws Exception {
        DetailsVO data = (DetailsVO)element;
        if (data.isMemoryLeak()) {
            return new Color(255, 235, 230);
        }
        if (data.getEventName().equals("free")) {
            return new Color(153, 255, 153);
        }
        return null;
    }

    public Color getForeground(Object element, XViewerColumn viewerColumn, int columnIndex) throws Exception {
        switch (columnIndex) {
            case 0: {
                return new Color(51, 102, 204);
            }
            case 4: {
                return new Color(102, 102, 255);
            }
        }
        return null;
    }

    public Font getFont(Object element, XViewerColumn viewerColumn, int columnIndex) throws Exception {
        return null;
    }
}

