/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.tracing;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.ui.tracing.AddressInfoVO;
import com.espressif.idf.ui.tracing.DetailsVO;
import com.espressif.idf.ui.tracing.Messages;
import com.espressif.idf.ui.tracing.TracingCallersView;
import com.espressif.idf.ui.tracing.TracingJsonParser;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.nebula.widgets.xviewer.customize.XViewerCustomMenu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class TracingViewerCustomMenu
extends XViewerCustomMenu {
    private Action showCallStackAction;
    private TracingJsonParser tracingJsonParser;

    public TracingViewerCustomMenu(TracingJsonParser tracingJsonParser) {
        this.tracingJsonParser = tracingJsonParser;
    }

    protected void setupActions() {
        super.setupActions();
        this.showCallStackAction = new ShowCallStackAction();
    }

    public void setupMenuForTable(MenuManager menuManager) {
        menuManager.add((IAction)this.showCallStackAction);
        menuManager.add((IContributionItem)new Separator());
        super.setupMenuForTable(menuManager);
    }

    private class ShowCallStackAction
    extends Action {
        private ShowCallStackAction() {
            super(Messages.TracingAnalysisEditor_DetailsContextMenuShowCallers);
        }

        public void run() {
            TreeItem[] treeItems = TracingViewerCustomMenu.this.xViewer.getTree().getSelection();
            DetailsVO detailsVO = (DetailsVO)treeItems[0].getData();
            ArrayList<AddressInfoVO> addressInfoVOs = new ArrayList<AddressInfoVO>();
            for (String callerAdderess : detailsVO.getEventsVO().getCallersAddressList()) {
                AddressInfoVO addressInfoVO = TracingViewerCustomMenu.this.tracingJsonParser.getCallersAddressMap().get(callerAdderess);
                if (addressInfoVO == null) continue;
                addressInfoVOs.add(addressInfoVO);
            }
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.espressif.idf.ui.views.tracingcallersview");
                TracingCallersView tracingCallersView = (TracingCallersView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("com.espressif.idf.ui.views.tracingcallersview");
                tracingCallersView.setAddressInfoVOs(addressInfoVOs);
                tracingCallersView.refreshTable();
                tracingCallersView.expandAll();
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.espressif.idf.ui.views.tracingcallersview");
            }
            catch (Exception e) {
                Logger.log((Exception)e);
            }
        }

        public String getToolTipText() {
            return Messages.TracingAnalysisEditor_DetailsContextMenuShowCallersTooltip;
        }
    }
}

