/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.size;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class IDFSizeComparator
extends ViewerComparator {
    private LinkedList<Integer> sortColumns = new LinkedList();
    private boolean ascending = true;

    public IDFSizeComparator() {
        int i = 0;
        while (i < 9) {
            this.sortColumns.add(i);
            ++i;
        }
    }

    public int getSortColumn() {
        return this.sortColumns.getFirst();
    }

    public void setSortColumn(int column) {
        if (column == this.getSortColumn()) {
            return;
        }
        Integer sortColumn = column;
        this.sortColumns.remove(sortColumn);
        this.sortColumns.addFirst(sortColumn);
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public int compare(Viewer viewer, Object a, Object b) {
        int result = 0;
        Iterator i = this.sortColumns.iterator();
        while (i.hasNext() && result == 0) {
            int column = (Integer)i.next();
            result = this.compareColumn(viewer, a, b, column);
        }
        return this.ascending ? result : -1 * result;
    }

    private int compareColumn(Viewer viewer, Object a, Object b, int columnNumber) {
        IBaseLabelProvider baseLabel = ((TreeViewer)viewer).getLabelProvider();
        if (baseLabel instanceof ITableLabelProvider) {
            ITableLabelProvider tableProvider = (ITableLabelProvider)baseLabel;
            String e1p = tableProvider.getColumnText(a, columnNumber);
            String e2p = tableProvider.getColumnText(b, columnNumber);
            if (e1p != null && e2p != null) {
                if (columnNumber == 0) {
                    return this.getComparator().compare(e1p, e2p);
                }
                return (int)(Long.valueOf(e1p) - Long.valueOf(e2p));
            }
        }
        return 0;
    }
}

