/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.preferences;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.ui.preferences.Messages;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class EspresssifPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String NUMBER_OF_LINES = "numberOfLines";
    public static final String NUMBER_OF_CHARS_IN_A_LINE = "numberOfCharsInALine";
    public static final int DEFAULT_SERIAL_MONITOR_NUBMER_OF_LINES = 1000;
    public static final int DEFAULT_SERIAL_MONITOR_NUMBER_OF_CHARS_IN_LINE = 500;
    private static final String GDB_SERVER_LAUNCH_TIMEOUT = "fGdbServerLaunchTimeout";
    private Text numberOfCharsInLineText;
    private Text numberLineText;
    private Text gdbSettingsText;
    private Button ccacheBtn;
    private Button automateHintsBtn;
    private Button hideErrorsOnIdfComponentsBtn;
    private Combo gitAssetsCombo;
    private Combo pythonWheelCombo;
    private Button automateClangdFormatCreationBtn;

    public EspresssifPreferencesPage() {
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore(InstanceScope.INSTANCE, "com.espressif.idf.core"));
        this.setDescription(Messages.EspresssifPreferencesPage_IDFSpecificPrefs);
    }

    public void init(IWorkbench workbench) {
        this.initializeDefaults();
    }

    protected Control createContents(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        mainComposite.setLayout((Layout)gridLayout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        mainComposite.setLayoutData((Object)data);
        this.addccacheControl(mainComposite);
        this.addGdbSettings(mainComposite);
        this.addSerialSettings(mainComposite);
        this.addBuildSettings(mainComposite);
        this.addClangdSettings(mainComposite);
        return mainComposite;
    }

    private void addClangdSettings(Composite mainComposite) {
        Group clangdOptionsGroup = new Group(mainComposite, 16);
        clangdOptionsGroup.setText(Messages.EspresssifPreferencesPage_ClangdSettingsGroupName);
        clangdOptionsGroup.setLayout((Layout)new GridLayout(1, false));
        this.automateClangdFormatCreationBtn = new Button((Composite)clangdOptionsGroup, 32);
        this.automateClangdFormatCreationBtn.setText(Messages.EspresssifPreferencesPage_AutoCreateClangFormatBtnName);
        this.automateClangdFormatCreationBtn.setToolTipText(Messages.EspresssifPreferencesPage_AutoCreateClangFormatTooltipMsg);
        this.automateClangdFormatCreationBtn.setSelection(this.getPreferenceStore().getBoolean("automateClangFormatFileCreation"));
    }

    private void addBuildSettings(Composite mainComposite) {
        Group buildGroup = new Group(mainComposite, 16);
        buildGroup.setText(Messages.EspresssifPreferencesPage_BuildGroupTxt);
        buildGroup.setLayout((Layout)new GridLayout(1, false));
        this.automateHintsBtn = new Button((Composite)buildGroup, 32);
        this.automateHintsBtn.setText(Messages.EspresssifPreferencesPage_SearchHintsCheckBtn);
        this.automateHintsBtn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.automateHintsBtn.setToolTipText(Messages.EspresssifPreferencesPage_SearchHintsTooltip);
        this.automateHintsBtn.setSelection(this.getPreferenceStore().getBoolean("automateHintsStatus"));
        this.hideErrorsOnIdfComponentsBtn = new Button((Composite)buildGroup, 32);
        this.hideErrorsOnIdfComponentsBtn.setText(Messages.EspresssifPreferencesPage_HideErrprOnIdfComponentsBtn);
        this.hideErrorsOnIdfComponentsBtn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.hideErrorsOnIdfComponentsBtn.setToolTipText(Messages.EspresssifPreferencesPage_HideErrprOnIdfComponentsToolTip);
        this.hideErrorsOnIdfComponentsBtn.setSelection(this.getPreferenceStore().getBoolean("hideErrorsOnIdfDerivedFiles"));
    }

    private void addccacheControl(Composite mainComposite) {
        Composite ccacheComp = new Composite(mainComposite, 16);
        ccacheComp.setLayout((Layout)new GridLayout(1, false));
        ccacheComp.setLayoutData((Object)new GridData(4, 0, true, false));
        this.ccacheBtn = new Button(ccacheComp, 32);
        this.ccacheBtn.setText(Messages.EspresssifPreferencesPage_EnableCCache);
        this.ccacheBtn.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.ccacheBtn.setToolTipText(Messages.EspresssifPreferencesPage_CCacheToolTip);
        this.ccacheBtn.setSelection(this.getPreferenceStore().getBoolean("cmakeCCacheStatus"));
    }

    private void addSerialSettings(Composite parent) {
        Group serialGroup = new Group(parent, 16);
        serialGroup.setText(Messages.SerialMonitorPage_GroupHeading);
        serialGroup.setLayout((Layout)new GridLayout(2, false));
        Label numberOfCharsInLineLabel = new Label((Composite)serialGroup, 0);
        numberOfCharsInLineLabel.setText(Messages.SerialMonitorPage_Field_NumberOfCharsInLine);
        this.numberOfCharsInLineText = new Text((Composite)serialGroup, 2052);
        this.numberOfCharsInLineText.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.numberOfCharsInLineText.setText(Integer.toString(this.getPreferenceStore().getInt(NUMBER_OF_CHARS_IN_A_LINE)));
        Label numberLineLabel = new Label((Composite)serialGroup, 0);
        numberLineLabel.setText(Messages.SerialMonitorPage_Field_NumberOfLines);
        this.numberLineText = new Text((Composite)serialGroup, 2052);
        this.numberLineText.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.numberLineText.setText(Integer.toString(this.getPreferenceStore().getInt(NUMBER_OF_LINES)));
    }

    private void addGdbSettings(Composite parent) {
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        Composite gdbGroup = new Composite(parent, 16);
        gdbGroup.setLayout((Layout)new GridLayout(2, false));
        gdbGroup.setLayoutData((Object)data);
        Label gdbSettingLabel = new Label(gdbGroup, 0);
        gdbSettingLabel.setText(Messages.GDBServerTimeoutPage_TimeoutField);
        this.gdbSettingsText = new Text(gdbGroup, 2052);
        this.gdbSettingsText.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.gdbSettingsText.setText(Integer.toString(this.getPreferenceStore().getInt(GDB_SERVER_LAUNCH_TIMEOUT)));
    }

    public boolean performOk() {
        try {
            int gdbTimeout = Integer.parseInt(this.gdbSettingsText.getText());
            this.getPreferenceStore().setValue(GDB_SERVER_LAUNCH_TIMEOUT, gdbTimeout);
            int numberOfCharInLines = Integer.parseInt(this.numberOfCharsInLineText.getText());
            this.getPreferenceStore().setValue(NUMBER_OF_CHARS_IN_A_LINE, numberOfCharInLines);
            int numberOfLines = Integer.parseInt(this.numberLineText.getText());
            this.getPreferenceStore().setValue(NUMBER_OF_LINES, numberOfLines);
            this.getPreferenceStore().setValue("cmakeCCacheStatus", this.ccacheBtn.getSelection());
            this.getPreferenceStore().setValue("automateHintsStatus", this.automateHintsBtn.getSelection());
            boolean prevMarkerValue = this.getPreferenceStore().getBoolean("hideErrorsOnIdfDerivedFiles");
            this.getPreferenceStore().setValue("hideErrorsOnIdfDerivedFiles", this.hideErrorsOnIdfComponentsBtn.getSelection());
            if (!prevMarkerValue && this.hideErrorsOnIdfComponentsBtn.getSelection()) {
                IDFCorePlugin.ERROR_MARKER_LISTENER.initialMarkerCleanup();
            }
            this.getPreferenceStore().setValue("automateClangFormatFileCreation", this.automateClangdFormatCreationBtn.getSelection());
        }
        catch (Exception e) {
            Logger.log((Exception)e);
            return false;
        }
        return true;
    }

    protected void performDefaults() {
        this.gdbSettingsText.setText(Integer.toString(this.getPreferenceStore().getDefaultInt(GDB_SERVER_LAUNCH_TIMEOUT)));
        this.numberLineText.setText(Integer.toString(this.getPreferenceStore().getDefaultInt(NUMBER_OF_LINES)));
        this.numberOfCharsInLineText.setText(Integer.toString(this.getPreferenceStore().getDefaultInt(NUMBER_OF_CHARS_IN_A_LINE)));
        this.ccacheBtn.setSelection(this.getPreferenceStore().getBoolean("cmakeCCacheStatus"));
        this.automateHintsBtn.setSelection(this.getPreferenceStore().getBoolean("automateHintsStatus"));
        this.hideErrorsOnIdfComponentsBtn.setSelection(this.getPreferenceStore().getBoolean("hideErrorsOnIdfDerivedFiles"));
        this.automateClangdFormatCreationBtn.setSelection(this.getPreferenceStore().getBoolean("automateClangFormatFileCreation"));
        this.gitAssetsCombo.setText(this.gitAssetsCombo.getItem(0));
        this.pythonWheelCombo.setText(this.pythonWheelCombo.getItem(0));
    }

    private void initializeDefaults() {
        this.getPreferenceStore().setDefault(GDB_SERVER_LAUNCH_TIMEOUT, 25);
        this.getPreferenceStore().setDefault(NUMBER_OF_CHARS_IN_A_LINE, 500);
        this.getPreferenceStore().setDefault(NUMBER_OF_LINES, 1000);
        this.getPreferenceStore().setDefault("cmakeCCacheStatus", true);
        this.getPreferenceStore().setDefault("automateHintsStatus", true);
        this.getPreferenceStore().setDefault("hideErrorsOnIdfDerivedFiles", true);
        this.getPreferenceStore().setDefault("automateClangFormatFileCreation", true);
    }
}

