/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.nvs.dialog;

import com.espressif.idf.core.build.NvsTableBean;
import com.espressif.idf.core.util.NvsTableDataService;
import com.espressif.idf.ui.nvs.dialog.Messages;
import com.espressif.idf.ui.nvs.dialog.NvsColumn;
import com.espressif.idf.ui.nvs.dialog.NvsTableEditorLabelProvider;
import java.util.Map;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class NvsEditorSupportFactory {
    private TableViewer tableViewer;
    private Map<NvsColumn, CellEditor> cellEditors;
    private Runnable markDirtyRunnable;

    public NvsEditorSupportFactory(TableViewer tableViewer, Map<NvsColumn, CellEditor> cellEditors, Runnable markDirtyRunnable) {
        this.tableViewer = tableViewer;
        this.cellEditors = cellEditors;
        this.markDirtyRunnable = markDirtyRunnable;
    }

    public NvsTableEditorLabelProvider createLabelProvider(final NvsColumn column) {
        return new NvsTableEditorLabelProvider(){

            @Override
            public int getColumnIndex() {
                return column.getIndex();
            }

            @Override
            public String getColumnText(NvsTableBean bean) {
                switch (column) {
                    case KEY: {
                        return bean.getKey();
                    }
                    case TYPE: {
                        return bean.getType();
                    }
                    case ENCODING: {
                        return bean.getEncoding();
                    }
                    case VALUE: {
                        return bean.getValue();
                    }
                }
                return "";
            }

            @Override
            public String getToolTipText(Object element) {
                if (NvsEditorSupportFactory.this.tableViewer.getElementAt(0).equals(element)) {
                    return Messages.NvsEditorDialog_FirstRowIsFixedInfoMsg;
                }
                return super.getToolTipText(element);
            }

            public Color getBackground(Object element) {
                if (column != NvsColumn.KEY && NvsEditorSupportFactory.this.tableViewer.getElementAt(0).equals(element)) {
                    return Display.getCurrent().getSystemColor(19);
                }
                return null;
            }
        };
    }

    public EditingSupport createEditingSupport(NvsColumn column) {
        switch (column) {
            case KEY: {
                return new NvsKeyEditingSupport();
            }
            case TYPE: {
                return new NvsTypeEditingSupport();
            }
            case ENCODING: {
                return new NvsEncodingEditingSupport();
            }
            case VALUE: {
                return new NvsValueEditingSupport();
            }
        }
        return null;
    }

    private abstract class BaseNvsEditingSupport
    extends EditingSupport {
        public BaseNvsEditingSupport() {
            super((ColumnViewer)NvsEditorSupportFactory.this.tableViewer);
        }

        protected boolean canEdit(Object element) {
            return !NvsEditorSupportFactory.this.tableViewer.getElementAt(0).equals(element);
        }
    }

    private class NvsEncodingEditingSupport
    extends BaseNvsEditingSupport {
        private NvsEncodingEditingSupport() {
        }

        protected CellEditor getCellEditor(Object element) {
            NvsTableBean bean = (NvsTableBean)element;
            ((ComboBoxCellEditor)NvsEditorSupportFactory.this.cellEditors.get((Object)NvsColumn.ENCODING)).setItems(NvsTableDataService.getEncodings((String)bean.getType()));
            return NvsEditorSupportFactory.this.cellEditors.get((Object)NvsColumn.ENCODING);
        }

        protected Object getValue(Object element) {
            NvsTableBean bean = (NvsTableBean)element;
            String stringValue = bean.getEncoding();
            String[] choices = NvsTableDataService.getEncodings((String)bean.getType());
            int i = 0;
            while (i < choices.length) {
                if (stringValue.equals(choices[i])) {
                    return i;
                }
                ++i;
            }
            return 0;
        }

        protected void setValue(Object element, Object value) {
            NvsTableBean bean = (NvsTableBean)element;
            String[] encodings = NvsTableDataService.getEncodings((String)bean.getType());
            if (encodings.length > (Integer)value) {
                bean.setEncoding(encodings[(Integer)value]);
            }
            NvsEditorSupportFactory.this.tableViewer.update(element, null);
            NvsEditorSupportFactory.this.markDirtyRunnable.run();
        }
    }

    private class NvsKeyEditingSupport
    extends EditingSupport {
        public NvsKeyEditingSupport() {
            super((ColumnViewer)NvsEditorSupportFactory.this.tableViewer);
        }

        protected CellEditor getCellEditor(Object element) {
            return NvsEditorSupportFactory.this.cellEditors.get((Object)NvsColumn.KEY);
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            return ((NvsTableBean)element).getKey();
        }

        protected void setValue(Object element, Object value) {
            ((NvsTableBean)element).setKey((String)value);
            NvsEditorSupportFactory.this.tableViewer.update(element, null);
            NvsEditorSupportFactory.this.markDirtyRunnable.run();
        }
    }

    private class NvsTypeEditingSupport
    extends BaseNvsEditingSupport {
        private NvsTypeEditingSupport() {
        }

        protected CellEditor getCellEditor(Object element) {
            return NvsEditorSupportFactory.this.cellEditors.get((Object)NvsColumn.TYPE);
        }

        protected Object getValue(Object element) {
            String stringValue = ((NvsTableBean)element).getType();
            String[] choices = NvsTableDataService.getTypes();
            int i = 0;
            while (i < choices.length) {
                if (stringValue.equals(choices[i])) {
                    return i;
                }
                ++i;
            }
            return 0;
        }

        protected void setValue(Object element, Object value) {
            NvsTableBean bean = (NvsTableBean)element;
            String newType = NvsTableDataService.getTypes()[(Integer)value];
            if (newType.contentEquals(bean.getType())) {
                return;
            }
            bean.setType(newType);
            String[] encodings = NvsTableDataService.getEncodings((String)bean.getType());
            ((ComboBoxCellEditor)NvsEditorSupportFactory.this.cellEditors.get((Object)NvsColumn.ENCODING)).setItems(encodings);
            if (encodings.length > 0) {
                bean.setEncoding(encodings[0]);
            }
            NvsEditorSupportFactory.this.tableViewer.update(element, new String[]{NvsColumn.TYPE.getDisplayName(), NvsColumn.ENCODING.getDisplayName()});
            NvsEditorSupportFactory.this.markDirtyRunnable.run();
        }
    }

    private class NvsValueEditingSupport
    extends BaseNvsEditingSupport {
        private NvsValueEditingSupport() {
        }

        protected CellEditor getCellEditor(Object element) {
            return NvsEditorSupportFactory.this.cellEditors.get((Object)NvsColumn.VALUE);
        }

        protected Object getValue(Object element) {
            return ((NvsTableBean)element).getValue();
        }

        protected void setValue(Object element, Object value) {
            ((NvsTableBean)element).setValue((String)value);
            NvsEditorSupportFactory.this.tableViewer.update(element, null);
            NvsEditorSupportFactory.this.markDirtyRunnable.run();
        }
    }
}

