/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.installcomponents.container;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.StringUtil;
import com.espressif.idf.ui.installcomponents.Messages;
import com.espressif.idf.ui.installcomponents.handler.InstallCommandHandler;
import com.espressif.idf.ui.installcomponents.vo.ComponentDetailsVO;
import com.espressif.idf.ui.installcomponents.vo.ComponentVO;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ComponentContainer {
    private ComponentVO componentVO;
    private ComponentDetailsVO componentDetailsVO;
    private Composite parent;
    private Group controlGroup;
    private Text detailsText;
    private Label targetsLabel;
    private Label versionLabel;
    private Button installButton;
    private Button openReadMe;
    private IProject project;
    private Composite btnComposite;
    private Font boldFont;
    private GridData layoutData;

    public ComponentContainer(ComponentVO componentVO, Composite parent, IProject project) {
        this.componentVO = componentVO;
        this.parent = parent;
        this.componentDetailsVO = componentVO != null ? componentVO.getComponentDetails() : null;
        this.project = project;
    }

    public Point createControl() {
        this.controlGroup = new Group(this.parent, 16);
        this.controlGroup.setLayout((Layout)new GridLayout());
        this.layoutData = new GridData(4, 4, true, false);
        this.controlGroup.setLayoutData((Object)this.layoutData);
        this.controlGroup.setText(this.componentVO.getName().toUpperCase());
        this.boldFont = new Font((Device)this.controlGroup.getDisplay(), new FontData("Arial", 8, 1));
        this.controlGroup.setFont(this.boldFont);
        if (this.componentDetailsVO != null && this.componentDetailsVO.getDescription() != null) {
            this.detailsText = new Text((Composite)this.controlGroup, 66);
            this.detailsText.setLayoutData((Object)new GridData(1808));
            this.detailsText.setText(this.componentVO.getComponentDetails().getDescription());
        }
        if (this.componentDetailsVO != null && this.componentDetailsVO.getTargets() != null) {
            this.targetsLabel = new Label((Composite)this.controlGroup, 0);
            StringBuilder sbTargets = new StringBuilder();
            sbTargets.append(this.componentVO.getComponentDetails().getTargets().get(0));
            int i = 0;
            while (i < this.componentVO.getComponentDetails().getTargets().size()) {
                sbTargets.append(", ");
                sbTargets.append(this.componentVO.getComponentDetails().getTargets().get(i));
                ++i;
            }
            this.targetsLabel.setText(sbTargets.toString());
        }
        if (this.componentDetailsVO != null && !StringUtil.isEmpty((String)this.componentDetailsVO.getVersion())) {
            this.versionLabel = new Label((Composite)this.controlGroup, 0);
            this.versionLabel.setText(this.componentDetailsVO.getVersion());
        }
        this.btnComposite = new Composite((Composite)this.controlGroup, 0);
        this.btnComposite.setLayout((Layout)new GridLayout(2, true));
        if (this.componentDetailsVO != null && !StringUtil.isEmpty((String)this.componentDetailsVO.getReadMe())) {
            this.openReadMe = new Button(this.btnComposite, 8);
            this.openReadMe.setText(Messages.InstallComponents_OpenReadmeButton);
            this.openReadMe.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String url = ComponentContainer.this.componentDetailsVO.getReadMe();
                    try {
                        if (StringUtil.isEmpty((String)url)) {
                            return;
                        }
                        Program.launch((String)url);
                    }
                    catch (Exception e1) {
                        Logger.log((Exception)e1);
                    }
                }
            });
        }
        this.installButton = new Button(this.btnComposite, 8);
        this.installButton.setText(Messages.InstallComponents_InstallButton);
        if (this.componentVO.isComponentAdded()) {
            this.installButton.setText(Messages.InstallComponents_InstallButtonAlreadyAdded);
            this.installButton.setEnabled(false);
        }
        final InstallCommandHandler installCommandHandler = new InstallCommandHandler(this.componentVO.getName(), this.componentVO.getNamespace(), this.componentDetailsVO != null && this.componentDetailsVO.getVersion() != null ? this.componentDetailsVO.getVersion() : "", this.project);
        this.installButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    installCommandHandler.executeInstallCommand();
                }
                catch (Exception e1) {
                    Logger.log((Exception)e1);
                }
            }
        });
        return this.controlGroup.getSize();
    }

    public void dispose() {
        if (this.openReadMe != null) {
            this.openReadMe.dispose();
            this.openReadMe = null;
        }
        if (this.boldFont != null) {
            this.boldFont.dispose();
            this.boldFont = null;
        }
        if (this.installButton != null) {
            this.installButton.dispose();
            this.installButton = null;
        }
        if (this.versionLabel != null) {
            this.versionLabel.dispose();
            this.versionLabel = null;
        }
        if (this.targetsLabel != null) {
            this.targetsLabel.dispose();
            this.targetsLabel = null;
        }
        if (this.detailsText != null) {
            this.detailsText.dispose();
            this.detailsText = null;
        }
        if (this.btnComposite != null) {
            this.btnComposite.dispose();
            this.btnComposite = null;
        }
        if (this.controlGroup != null) {
            this.controlGroup.dispose();
            this.controlGroup = null;
        }
        if (this.parent != null) {
            this.parent.dispose();
            this.parent = null;
        }
    }
}

