/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.installcomponents;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.ui.installcomponents.container.InstallComponentsCompositePage;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

public class InstallComponentsEditor
extends MultiPageEditorPart {
    public static String EDITOR_ID = "com.espressif.idf.ui.installComponents";
    private IFile componentsJsonFile;
    private IProject project;
    private InstallComponentsCompositePage installComponentsCompositePage;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        FileEditorInput editorInput = (FileEditorInput)this.getEditorInput();
        this.componentsJsonFile = editorInput.getFile();
        this.project = this.componentsJsonFile.getProject();
        this.setPartName(this.project.getName());
        this.installComponentsCompositePage = new InstallComponentsCompositePage(this.componentsJsonFile, this.project);
    }

    protected void createPages() {
        String osString = this.componentsJsonFile.getLocation().toOSString();
        Logger.log((String)("Editor input:" + osString));
        try {
            this.createComponentsInstallPage();
        }
        catch (IOException e) {
            Logger.log((Exception)e);
        }
    }

    private void createComponentsInstallPage() throws IOException {
        Composite parent = new Composite(this.getContainer(), 0);
        parent.setLayout((Layout)new FillLayout(512));
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 2820);
        scrolledComposite.setLayout((Layout)new FillLayout(512));
        scrolledComposite.setAlwaysShowScrollBars(true);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.addListener(11, event -> {
            int width = scrolledComposite.getClientArea().width;
            scrolledComposite.setMinSize(parent.computeSize(width, -1, true));
        });
        Composite subContainer = new Composite((Composite)scrolledComposite, 0);
        GridLayout gridLayout = new GridLayout(4, true);
        subContainer.setLayout((Layout)gridLayout);
        this.installComponentsCompositePage.createControls(subContainer);
        scrolledComposite.setContent((Control)subContainer);
        int index = this.addPage((Control)parent);
        this.setPageText(index, "Install Components");
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
        this.installComponentsCompositePage.dispose();
    }
}

