/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.help;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.IDFUtil;
import com.espressif.idf.core.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class LaunchEspIdfDocHandler
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
        try {
            IWebBrowser browser = support.getExternalBrowser();
            if (browser != null) {
                URL docsUrl = this.getDocsUrl(this.getIDFVersion());
                Logger.log((String)docsUrl.getPath());
                browser.openURL(docsUrl);
            }
        }
        catch (IOException | PartInitException e) {
            Logger.log((Exception)e);
        }
        return null;
    }

    protected String getIDFVersion() {
        String branch;
        String LATEST = "latest";
        String idfPath = IDFUtil.getIDFPath();
        if (!StringUtil.isEmpty((String)idfPath) && (branch = this.gitBranchName(idfPath)) != null) {
            if (branch.equals("master")) {
                return LATEST;
            }
            if (branch.contains("release")) {
                return branch.replace("/", "-");
            }
        }
        return LATEST;
    }

    protected String gitBranchName(String gitPath) {
        try {
            Git git = this.init(gitPath);
            if (git != null) {
                return git.getRepository().getBranch();
            }
        }
        catch (IOException e) {
            Logger.log((Exception)e);
        }
        return null;
    }

    protected Git init(String gitPath) throws IOException {
        File gitFolder = new File(gitPath);
        File gitDB = new File(gitFolder, ".git");
        if (gitDB.exists() && gitDB.isDirectory()) {
            FileRepositoryBuilder builder = new FileRepositoryBuilder();
            Repository repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.setGitDir(gitDB)).readEnvironment()).findGitDir()).build();
            return new Git(repository);
        }
        return null;
    }

    protected URL getDocsUrl(String versionArg) throws MalformedURLException {
        return new URL("https://docs.espressif.com/projects/esp-idf/en/" + versionArg + "/index.html");
    }
}

