/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.dialogs;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.Messages;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;

public class MessageLinkDialog
extends MessageDialog {
    private static final String DO_NOT_SHOW_MSG = "DO_NOT_SHOW_MSG";
    private static IEclipsePreferences preferences;

    public MessageLinkDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, int defaultIndex, String[] dialogButtonLabels) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, defaultIndex, dialogButtonLabels);
    }

    protected Control createMessageArea(Composite composite) {
        Image image = this.getImage();
        if (image != null) {
            this.imageLabel = new Label(composite, 0);
            image.setBackground(this.imageLabel.getBackground());
            this.imageLabel.setImage(image);
            GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
        }
        if (this.message != null) {
            Link link = new Link(composite, this.getMessageLabelStyle());
            link.setText(this.message);
            link.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    Program.launch((String)event.text);
                }
            });
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)link);
        }
        return composite;
    }

    protected Control createCustomArea(Composite parent) {
        final Button checkBox = new Button(parent, 32);
        checkBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                preferences.putBoolean(MessageLinkDialog.DO_NOT_SHOW_MSG, checkBox.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        checkBox.setText(Messages.MsgLinkDialog_DoNotShowMsg);
        return parent;
    }

    public static void openWarning(Shell parent, String title, String message) {
        preferences = InstanceScope.INSTANCE.getNode("com.espressif.idf.core");
        if (!preferences.getBoolean(DO_NOT_SHOW_MSG, false)) {
            MessageLinkDialog.open(4, parent, title, message, 0);
        }
    }

    protected void buttonPressed(int buttonId) {
        try {
            preferences.flush();
        }
        catch (BackingStoreException e1) {
            Logger.log((Exception)((Object)e1));
        }
        super.buttonPressed(buttonId);
    }

    public static boolean open(int kind, Shell parent, String title, String message, int style) {
        MessageLinkDialog dialog = new MessageLinkDialog(parent, title, null, message, kind, 0, new String[]{IDialogConstants.OK_LABEL});
        dialog.setShellStyle(dialog.getShellStyle() | (style &= 0x10000000));
        return dialog.open() == 0;
    }
}

