/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.dialogs;

import com.espressif.idf.core.build.ReHintPair;
import com.espressif.idf.core.util.HintsUtil;
import com.espressif.idf.ui.dialogs.Messages;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class HintsView
extends ViewPart {
    private TableViewer hintsTableViewer;
    private Table hintsTable;
    private final String[] titles = new String[]{"Error Type", "Hint"};
    private Text searchField;
    private List<ReHintPair> reHintsList;

    public void createPartControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, true);
        container.setLayout((Layout)layout);
        this.reHintsList = HintsUtil.getReHintsList((File)new File(HintsUtil.getHintsYmlPath()));
        if (this.reHintsList.isEmpty()) {
            CLabel errorField = new CLabel(container, 256);
            errorField.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
            errorField.setText(MessageFormat.format(Messages.HintsYmlNotFoundErrMsg, HintsUtil.getHintsYmlPath()));
            return;
        }
        this.createSearchField(container);
        this.createHintsViewer(container);
    }

    private void createHintsViewer(Composite container) {
        this.hintsTableViewer = new TableViewer(container, 68354);
        this.createColumns(container);
        this.hintsTable = this.hintsTableViewer.getTable();
        this.hintsTable.setHeaderVisible(true);
        this.hintsTable.setLinesVisible(true);
        this.hintsTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.hintsTableViewer.setInput(this.reHintsList);
        this.resizeAllColumns();
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        this.hintsTableViewer.getControl().setLayoutData((Object)gridData);
    }

    private void resizeAllColumns() {
        TableColumn[] tableColumnArray = this.hintsTableViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tc = tableColumnArray[n2];
            tc.pack();
            ++n2;
        }
    }

    private void createColumns(Composite container) {
        TableViewerColumn col = this.createTableViewerColumn(this.titles[0]);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Optional reOptionalPattern = ((ReHintPair)element).getRe();
                return reOptionalPattern.isPresent() ? ((Pattern)reOptionalPattern.get()).pattern() : "";
            }
        });
        col = this.createTableViewerColumn(this.titles[1]);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
            }

            public String getText(Object element) {
                return ((ReHintPair)element).getHint();
            }
        });
        col.getViewer().addDoubleClickListener(event -> {
            StructuredSelection selection = (StructuredSelection)event.getViewer().getSelection();
            MessageDialog.openInformation((Shell)container.getShell(), (String)Messages.HintDetailsTitle, (String)((ReHintPair)selection.getFirstElement()).getHint());
        });
    }

    private TableViewerColumn createTableViewerColumn(String title) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.hintsTableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    private void createSearchField(Composite container) {
        GridData dataName = new GridData();
        dataName.grabExcessHorizontalSpace = true;
        dataName.horizontalAlignment = 4;
        this.searchField = new Text(container, 2948);
        this.searchField.setMessage(Messages.FilterMessage);
        this.searchField.setLayoutData((Object)dataName);
        this.searchField.addModifyListener(e -> {
            ArrayList allMatchesList = new ArrayList();
            this.reHintsList.stream().filter(reHintEntry -> reHintEntry.getRe().map(pattern -> pattern.matcher(this.searchField.getText()).find()).orElse(false)).forEach(allMatchesList::add);
            if (allMatchesList.isEmpty()) {
                this.reHintsList.stream().filter(reHintEntry -> reHintEntry.getRe().map(pattern -> pattern.pattern().contains(this.searchField.getText())).orElse(false)).forEach(allMatchesList::add);
            }
            this.hintsTableViewer.setInput(allMatchesList.isEmpty() ? this.reHintsList : allMatchesList);
            this.hintsTableViewer.refresh();
        });
    }

    public void setFocus() {
        if (this.searchField != null) {
            this.searchField.setFocus();
        }
    }
}

