/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui.dialogs;

import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.util.EspToolCommands;
import com.espressif.idf.ui.dialogs.Messages;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.cdt.serial.SerialPort;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EraseFlashDialog
extends TitleAreaDialog {
    private Combo comPortsCombo;
    private Text deviceInformationText;
    private String[] ports;
    private EspToolCommands espToolCommands;

    public EraseFlashDialog(Shell parent) {
        super(parent);
        try {
            this.ports = SerialPort.list();
            this.espToolCommands = new EspToolCommands();
        }
        catch (IOException e) {
            Logger.log((Exception)e);
        }
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(3, false);
        container.setLayout((Layout)layout);
        GridData comboLayoutData = new GridData();
        comboLayoutData.grabExcessHorizontalSpace = true;
        comboLayoutData.horizontalAlignment = 4;
        comboLayoutData.horizontalSpan = 2;
        Label comPortsLabel = new Label(container, 0);
        comPortsLabel.setText(Messages.EraseFlashDialog_ComPortLabel);
        this.comPortsCombo = new Combo(container, 8);
        String[] stringArray = this.ports;
        int n = this.ports.length;
        int n2 = 0;
        while (n2 < n) {
            String port = stringArray[n2];
            this.comPortsCombo.add(port);
            ++n2;
        }
        this.comPortsCombo.setLayoutData((Object)comboLayoutData);
        this.deviceInformationText = new Text(container, 2824);
        this.deviceInformationText.setText(Messages.EraseFlashDialog_DeviceInformationAreaInitialText);
        this.deviceInformationText.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.comPortsCombo.addSelectionListener((SelectionListener)new ComPortSelectionListener());
        return container;
    }

    public void create() {
        super.create();
        this.setTitle(Messages.EraseFlashDialog_Title);
        this.setMessage(Messages.EraseFlashDialog_InformationMessage, 1);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.EraseFlashDialog_Title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.EraseFlashDialog_OkButton, true);
        this.getButton(0).setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public boolean close() {
        if (this.espToolCommands.checkActiveFlashEraseProcess()) {
            boolean canClose = MessageDialog.openQuestion((Shell)this.getParentShell(), (String)Messages.EraseFlashDialog_EraseFlashInProcessMessageTitle, (String)Messages.EraseFlashDialog_EraseFlashInProcessMessageQuestion);
            if (!canClose) {
                return false;
            }
            this.espToolCommands.killEraseFlashProcess();
        }
        return super.close();
    }

    protected void okPressed() {
        this.setReturnCode(0);
        this.getButton(0).setEnabled(false);
        this.deviceInformationText.setText("Erasing Flash....");
        final String selectedPort = this.comPortsCombo.getText();
        this.comPortsCombo.setEnabled(false);
        this.deviceInformationText.setText("");
        Thread eraseFlashThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Process eraseFlashProcess = EraseFlashDialog.this.espToolCommands.eraseFlash(selectedPort);
                    InputStream targetIn = eraseFlashProcess.getInputStream();
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(targetIn));
                    String line = "";
                    while ((line = bufferedReader.readLine()) != null) {
                        String toWrite = line;
                        Display.getDefault().asyncExec(() -> {
                            if (!EraseFlashDialog.this.deviceInformationText.isDisposed()) {
                                EraseFlashDialog.this.deviceInformationText.append(toWrite + "\n");
                            }
                        });
                    }
                }
                catch (Exception e) {
                    Logger.log((Exception)e);
                }
                Display.getDefault().syncExec(() -> {
                    if (!EraseFlashDialog.this.comPortsCombo.isDisposed()) {
                        EraseFlashDialog.this.comPortsCombo.setEnabled(true);
                    }
                });
            }
        });
        eraseFlashThread.start();
    }

    protected Point getInitialSize() {
        return new Point(450, 300);
    }

    private class ComPortSelectionListener
    extends SelectionAdapter
    implements Runnable {
        private String selectedPort;
        private Thread infoThread;

        private ComPortSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            EraseFlashDialog.this.getButton(0).setEnabled(true);
            this.selectedPort = ((Combo)event.getSource()).getText();
            try {
                EraseFlashDialog.this.deviceInformationText.setText(Messages.EraseFlashDialog_LoadingMessage);
                this.infoThread = new Thread(this);
                this.infoThread.start();
            }
            catch (Exception exception) {
                Logger.log((Exception)exception);
            }
        }

        @Override
        public void run() {
            try {
                Process chipInfoProcess = EraseFlashDialog.this.espToolCommands.chipInformation(this.selectedPort);
                InputStream targetIn = chipInfoProcess.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(targetIn));
                int readCharInt = 0;
                while ((readCharInt = bufferedReader.read()) != -1) {
                    char charToWrite = (char)readCharInt;
                    Display.getDefault().asyncExec(() -> {
                        if (!EraseFlashDialog.this.deviceInformationText.isDisposed()) {
                            EraseFlashDialog.this.deviceInformationText.append(Character.toString(charToWrite));
                        }
                    });
                }
            }
            catch (Exception e) {
                Logger.log((Exception)e);
            }
        }
    }
}

