/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.ui;

import com.espressif.idf.core.build.Messages;
import com.espressif.idf.core.build.ReHintPair;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.resources.OpenDialogListenerSupport;
import com.espressif.idf.core.resources.PopupDialog;
import com.espressif.idf.core.resources.ResourceChangeListener;
import com.espressif.idf.ui.LaunchBarListener;
import com.espressif.idf.ui.dialogs.BuildView;
import com.espressif.idf.ui.dialogs.MessageLinkDialog;
import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.cdt.cmake.core.internal.Activator;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.launchbar.core.ILaunchBarListener;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class EspressifGeneralStartup
implements IStartup {
    private static final String BUILDHINTS_ID = "com.espressif.idf.ui.views.buildhints";
    private LaunchBarListener launchBarListener;

    public void earlyStartup() {
        this.hookDialogListeners();
        this.hookLaunchBarListeners();
    }

    private void hookDialogListeners() {
        OpenDialogListenerSupport.getSupport().addPropertyChangeListener(evt -> {
            PopupDialog popupDialog = PopupDialog.valueOf((String)evt.getPropertyName());
            switch (popupDialog) {
                case LOW_PARTITION_SIZE: {
                    this.openLowPartitionSizeDialog(evt);
                    break;
                }
                case AVAILABLE_HINTS: {
                    this.openAvailableHintsDialog(evt);
                    break;
                }
                case DISABLE_LAUNCHABAR_EVENTS: {
                    this.disableLaunchBarEvents();
                    break;
                }
                case ENABLE_LAUNCHBAR_EVENTS: {
                    this.enableLaunchBarEvents();
                    break;
                }
            }
        });
    }

    private void hookLaunchBarListeners() {
        this.launchBarListener = new LaunchBarListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new ResourceChangeListener((ILaunchBarListener)this.launchBarListener));
        ILaunchBarManager launchBarManager = (ILaunchBarManager)Activator.getService(ILaunchBarManager.class);
        launchBarManager.addListener((ILaunchBarListener)this.launchBarListener);
    }

    private void disableLaunchBarEvents() {
        LaunchBarListener.setIgnoreTargetChange(true);
    }

    private void enableLaunchBarEvents() {
        LaunchBarListener.setIgnoreTargetChange(false);
    }

    private void openAvailableHintsDialog(PropertyChangeEvent evt) {
        Display.getDefault().asyncExec(() -> {
            List errorHintPairs = (List)evt.getNewValue();
            if (errorHintPairs.isEmpty()) {
                this.updateBuildView(errorHintPairs);
                return;
            }
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(BUILDHINTS_ID);
            }
            catch (PartInitException e) {
                Logger.log((Exception)((Object)e));
            }
            this.updateBuildView(errorHintPairs);
        });
    }

    private void updateBuildView(List<ReHintPair> errorHintPairs) {
        BuildView view = (BuildView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(BUILDHINTS_ID);
        if (view != null) {
            view.updateReHintsPairs(errorHintPairs);
        }
    }

    private void openLowPartitionSizeDialog(PropertyChangeEvent evt) {
        Display.getDefault().asyncExec(() -> {
            Shell shell = Display.getDefault().getActiveShell();
            MessageLinkDialog.openWarning(shell, Messages.IncreasePartitionSizeTitle, MessageFormat.format(Messages.IncreasePartitionSizeMessage, evt.getNewValue(), evt.getOldValue(), "https://docs.espressif.com/projects/esp-idf/en/latest/esp32/api-guides/partition-tables.html?highlight=partitions%20csv#creating-custom-tables"));
        });
    }
}

