/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.variable;

import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.variable.UartDynamicVariable;
import java.util.Arrays;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.target.ILaunchTarget;

public class UartVariableResolver
implements IDynamicVariableResolver {
    public String resolveValue(IDynamicVariable variable, String argument) {
        return this.getAppropriateEnumVariable(variable).map(this::resolveForDynamicEnum).orElse(variable.getName());
    }

    private Optional<UartDynamicVariable> getAppropriateEnumVariable(IDynamicVariable variable) {
        return Arrays.stream(UartDynamicVariable.values()).filter(v -> v.getValue().equals(variable.getName())).findFirst();
    }

    private String resolveForDynamicEnum(UartDynamicVariable enumVariable) {
        switch (enumVariable) {
            case SERIAL_PORT: {
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        return this.getSerialPort();
    }

    private String getSerialPort() {
        return this.getActiveLaunchTarget().orElseGet(() -> ILaunchTarget.NULL_TARGET).getAttribute("com.espressif.idf.launch.serial.core.serialPort", "");
    }

    private Optional<ILaunchTarget> getActiveLaunchTarget() {
        try {
            return Optional.of(IDFCorePlugin.getService(ILaunchBarManager.class).getActiveLaunchTarget());
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
            return Optional.empty();
        }
    }
}

