/*
 * Decompiled with CFR 0.152.
 */
package com.espressif.idf.core.variable;

import com.espressif.idf.core.DefaultBoardProvider;
import com.espressif.idf.core.IDFCorePlugin;
import com.espressif.idf.core.configparser.EspConfigParser;
import com.espressif.idf.core.configparser.vo.Board;
import com.espressif.idf.core.logging.Logger;
import com.espressif.idf.core.variable.JtagDynamicVariable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.target.ILaunchTarget;

public class JtagVariableResolver
implements IDynamicVariableResolver {
    public String resolveValue(IDynamicVariable variable, String argument) {
        return this.getAppropriateEnumVariable(variable).map(this::resolveForDynamicEnum).orElse(variable.getName());
    }

    private Optional<JtagDynamicVariable> getAppropriateEnumVariable(IDynamicVariable variable) {
        return Arrays.stream(JtagDynamicVariable.values()).filter(v -> v.name().equals(variable.getName())).findFirst();
    }

    private String resolveForDynamicEnum(JtagDynamicVariable enumVariable) {
        switch (enumVariable) {
            case JTAG_FLASH_ARGS: {
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        return this.generatePartOfConfigOptionsForVoltage() + this.generatePartOfConfigOptionsForBoard();
    }

    private Optional<ILaunchTarget> getActiveLaunchTarget() {
        try {
            return Optional.of(IDFCorePlugin.getService(ILaunchBarManager.class).getActiveLaunchTarget());
        }
        catch (CoreException e) {
            Logger.log((Exception)((Object)e));
            return Optional.empty();
        }
    }

    private String generatePartOfConfigOptionsForVoltage() {
        ILaunchTarget activeILaunchTarget = this.getActiveLaunchTarget().orElseGet(() -> ILaunchTarget.NULL_TARGET);
        String selectedVoltage = activeILaunchTarget.getAttribute("com.espressif.idf.launch.serial.core.flash_voltage", "default");
        return selectedVoltage.equals("default") ? "" : String.format("-c 'set ESP32_FLASH_VOLTAGE' %s' ", selectedVoltage);
    }

    private String generatePartOfConfigOptionsForBoard() {
        String targetName;
        EspConfigParser parser = new EspConfigParser();
        ILaunchTarget activeILaunchTarget = this.getActiveLaunchTarget().orElseGet(() -> ILaunchTarget.NULL_TARGET);
        String board = activeILaunchTarget.getAttribute("com.espressif.idf.launch.serial.core.board", new DefaultBoardProvider().getDefaultBoard(targetName = activeILaunchTarget.getAttribute("com.espressif.idf.launch.serial.core.idfTarget", "")));
        int idx = board.lastIndexOf(" [usb://");
        String boardKey = idx != -1 ? board.substring(0, idx) : board;
        List<Board> boards = parser.getBoardsForTarget(targetName);
        List boardConfigs = boards.stream().filter(b -> b.name().equals(boardKey)).findFirst().map(Board::config_files).orElse(List.of());
        StringBuilder result = new StringBuilder();
        if (boardConfigs != null) {
            for (Object config : boardConfigs) {
                result.append(String.format("-f %s ", config));
            }
        }
        return result.toString();
    }
}

